/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.LoadDefault;

import Gbt.utility.Chassis.ChassisPowerCommand;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.FRU.FRUType;
import Gbt.utility.FRU.GetFRUCommand;
import Gbt.utility.LoadDefault.GetLoadDefaultStatusCommand;
import Gbt.utility.LoadDefault.TransferLoadDefaultConifgFilethroughIPMI;

public class LoadDefault {
    private boolean done;
    private boolean unmountStatus;
    private int unmountMaxRetry = 70;
    private int unmountRetry = 0;
    private String logMessage = "";
    private String progressMessage = "";
    private boolean uploadSuccess = false;
    private boolean skip = false;

    public boolean isUnmount() {
        return this.unmountStatus;
    }

    public boolean isComplete() {
        return this.done;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isSuccess() {
        return this.uploadSuccess;
    }

    public void reInitial() {
        this.done = false;
        this.unmountStatus = false;
        this.uploadSuccess = false;
        this.unmountRetry = 0;
        this.logMessage = "";
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void run(String IP, String BMCFile, String BIOSFile, String productNameFromFile, String boardProductFromFile, boolean loadBMC, boolean loadBIOS, String username, String password) {
        GetLoadDefaultStatusCommand gds;
        TransferLoadDefaultConifgFilethroughIPMI sendtoBMC;
        this.uploadSuccess = false;
        if (loadBMC) {
            this.log("Upload BMC config to " + IP + "...");
            this.uploadSuccess = true;
            sendtoBMC = new TransferLoadDefaultConifgFilethroughIPMI();
            sendtoBMC.run(IP, BMCFile, (byte)2, username, password);
            this.log(sendtoBMC.getMessage());
            sendtoBMC.close();
            this.log("Wait for checking status....");
            try {
                Thread.sleep(8000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            gds = new GetLoadDefaultStatusCommand();
            gds.run(IP, username, password);
            if (gds.isBMCSuccess()) {
                this.log("Upload success!");
                this.uploadSuccess = true;
            } else {
                if (gds.isCritical()) {
                    this.log(gds.getMessage());
                }
                this.log("Upload fail, please try again.");
                this.uploadSuccess = false;
            }
        }
        if (loadBIOS) {
            this.uploadSuccess = false;
            if (!this.checkproductName(IP, productNameFromFile, boardProductFromFile)) {
                this.log(IP + " system product/board product name is not compatible! Skip it.");
                this.done = true;
                this.skip = true;
                return;
            }
            this.log("Upload BIOS config to BMC...");
            sendtoBMC = new TransferLoadDefaultConifgFilethroughIPMI();
            sendtoBMC.run(IP, BIOSFile, (byte)1, username, password);
            this.log(sendtoBMC.getMessage());
            sendtoBMC.close();
            this.log("Wait for checking status....");
            try {
                Thread.sleep(8000L);
            }
            catch (InterruptedException gds2) {
                // empty catch block
            }
            gds = new GetLoadDefaultStatusCommand();
            gds.run(IP, username, password);
            if (gds.isBIOSSucess()) {
                this.log("Upload success!");
                this.uploadSuccess = true;
            } else {
                if (gds.isCritical()) {
                    this.log(gds.getMessage());
                }
                this.log("Upload fail, please try again.");
                this.uploadSuccess = false;
            }
        }
        this.done = true;
    }

    public boolean resetSystem(String IP) throws Exception {
        this.log("Send chassis power cycle.");
        ChassisPowerCommand command = new ChassisPowerCommand.Builder().setBMCIP(IP).setPowerCommand(PowerCommand.PowerCycle).build();
        if (!command.checkAll()) {
            return false;
        }
        if (!command.execute()) {
            return false;
        }
        command.close();
        return true;
    }

    public void checkUnmount(String IP, String uaername, String password) throws Exception {
        if (this.unmountRetry > this.unmountMaxRetry) {
            this.log("Waitting unmonut time out, skip it.");
            this.done = true;
            this.unmountStatus = false;
            return;
        }
        GetLoadDefaultStatusCommand gds = new GetLoadDefaultStatusCommand();
        gds.run(IP, uaername, password);
        if (gds.isUnmount()) {
            this.log("Load default complete.");
            this.unmountStatus = true;
            this.done = true;
        }
        ++this.unmountRetry;
    }

    private boolean checkproductName(String IP, String productNameFromFile, String boardProductFromFile) {
        if (productNameFromFile.equals("")) {
            return false;
        }
        this.log("Read product name from file: " + productNameFromFile);
        this.log("Read board product from file: " + boardProductFromFile);
        GetFRUCommand command = new GetFRUCommand.Builder().setFRUType(FRUType.FRU).setBMCIP(IP).build();
        if (!command.checkAll()) {
            return false;
        }
        if (!command.execute()) {
            return false;
        }
        String targetBoardProduct = command.getBoardInfo().getBoardProductName();
        String targetProductName = command.getProductInfo().get(0).getProductName();
        return targetProductName.equals(productNameFromFile) && targetBoardProduct.equals(boardProductFromFile);
    }

    private void log(String msg) {
        this.progressMessage = msg;
        System.out.println("[LoadDefault] " + this.progressMessage);
        this.logMessage = this.logMessage + this.progressMessage + "\n";
    }
}

