/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.NTP;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.NTP.NtpCommand;
import Gbt.utility.NTP.NtpJsonData;
import Gbt.utility.NTP.NtpOperationMode;
import Gbt.utility.NTP.NtpServerHostData;
import Gbt.utility.NTP.NtpTscMode;
import java.nio.charset.StandardCharsets;

public enum NtpCommandIpmiOptions implements GbtIPMIOptions<NtpCommand.Builder>
{
    SET_MODE(0, "Set NTP operation mode", -44),
    SET_SERVER_IP(1, "Set NTP server host address", -44),
    SET_UPDATE_FREQUENCY(2, "Set NTP update frequency", -44),
    GET_MODE(3, "Get NTP operation mode", -43),
    GET_SERVER_IP(4, "Get NTP server host address", -43),
    GET_UPDATE_FREQUENCY(5, "Get NTP update frequency", -43);

    private static final String SET_MODE_ITEM = "Set NTP operation mode";
    private static final String SET_SERVER_IP_ITEM = "Set NTP server host address";
    private static final String SET_UPDATE_FREQUENCY_ITEM = "Set NTP update frequency";
    private static final String GET_MODE_ITEM = "Get NTP operation mode";
    private static final String GET_SERVER_IP_ITEM = "Get NTP server host address";
    private static final String GET_UPDATE_FREQUENCY_ITEM = "Get NTP update frequency";
    private static final byte NET_FN = 46;
    private final int optionCode;
    private final String item;
    private final byte cmd;

    private NtpCommandIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(NtpCommand.Builder commandArgs) {
        switch (this) {
            case GET_MODE: {
                return new byte[]{10, 60, 0, 40, 0};
            }
            case GET_SERVER_IP: {
                return new byte[]{10, 60, 0, 40, 1, GbtCommonConverters.intToByte(commandArgs.serverIdCount + 1)};
            }
            case GET_UPDATE_FREQUENCY: {
                return new byte[]{10, 60, 0, 40, 2};
            }
            case SET_MODE: {
                return new byte[]{10, 60, 0, 40, 0, commandArgs.ntpUploadData.getOperationMode().getCode(), commandArgs.ntpUploadData.getTimeSynchronizationMethod().getCode()};
            }
            case SET_SERVER_IP: {
                byte[] reqHeaders = new byte[]{10, 60, 0, 40, 1};
                byte serverId = GbtCommonConverters.intToByte(commandArgs.ntpUploadData.getNtpServerHostData().get(commandArgs.serverIdCount).getId().intValue());
                byte[] serverHostBytes = commandArgs.ntpUploadData.getNtpServerHostData().get(commandArgs.serverIdCount).getServerHost().getBytes(StandardCharsets.UTF_8);
                byte[] finalOutput = new byte[reqHeaders.length + 1 + serverHostBytes.length];
                System.arraycopy(reqHeaders, 0, finalOutput, 0, reqHeaders.length);
                finalOutput[5] = serverId;
                System.arraycopy(serverHostBytes, 0, finalOutput, 6, serverHostBytes.length);
                return finalOutput;
            }
            case SET_UPDATE_FREQUENCY: {
                return new byte[]{10, 60, 0, 40, 2, GbtCommonConverters.intToByte(commandArgs.ntpUploadData.getFrequency())};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case GET_MODE: {
                NtpOperationMode opmode = NtpOperationMode.parse(gbtResponseData.getResponseData(3));
                if (opmode == NtpOperationMode.RequestedMode && gbtResponseData.getAllResponseData().length > 4) {
                    return new NtpJsonData().setOperationMode(opmode).setTimeSynchronizationMethod(NtpTscMode.parse(gbtResponseData.getResponseData(4)));
                }
                if (opmode == NtpOperationMode.RequestedMode) {
                    return new NtpJsonData().setOperationMode(opmode).setTimeSynchronizationMethod(NtpTscMode.UNKNOWN);
                }
                return new NtpJsonData().setOperationMode(opmode);
            }
            case GET_SERVER_IP: {
                byte[] serverHostBytes = new byte[gbtResponseData.getAllResponseData().length - 3];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, serverHostBytes, 0, serverHostBytes.length);
                return new NtpServerHostData().setServerHost(new String(serverHostBytes, StandardCharsets.UTF_8));
            }
            case GET_UPDATE_FREQUENCY: {
                return new NtpJsonData().setFrequency(gbtResponseData.getResponseData(3) & 0xFF);
            }
            case SET_MODE: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_SERVER_IP: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_UPDATE_FREQUENCY: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown parse option of ntp command.");
    }
}

