/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.NTP;

import com.fasterxml.jackson.annotation.JsonValue;

public enum NtpOperationMode {
    Unknown("Unknown", 0),
    Disable("Disable", 0),
    DaemonMode("Daemon Mode", 1),
    RequestedMode("Requested Mode", 2);

    private static final String DISABLE_MODE_ITEM = "disable";
    private static final String DAEMON_MODE_ITEM = "daemon";
    private static final String REQUESTED_MODE_ITEM = "requested";
    private final String value;
    private final byte code;

    private NtpOperationMode(String value, byte code) {
        this.value = value;
        this.code = code;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public byte getCode() {
        return this.code;
    }

    public static final NtpOperationMode parse(String rawString) {
        if (rawString == null) {
            return Disable;
        }
        switch (rawString.toLowerCase()) {
            case "disable": {
                return Disable;
            }
            case "daemon": {
                return DaemonMode;
            }
            case "requested": {
                return RequestedMode;
            }
        }
        return Unknown;
    }

    public static final NtpOperationMode parse(byte rawByte) {
        switch (rawByte) {
            case 0: {
                return Disable;
            }
            case 1: {
                return DaemonMode;
            }
            case 2: {
                return RequestedMode;
            }
        }
        return Unknown;
    }
}

