/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType20
extends SmbiosTypeBase {
    private String startingAddress;
    private String endingAddress;
    private String memoryDeviceHandle;
    private String memoryArrayMappedAddressHandle;
    private String partitionRowPosition;
    private String interleavePosition;
    private String interleavedDataDepth;
    private String extendedStartingAddress;
    private String extendedEndingAddress;
    private String rangeSize;
    private byte[] startingAddressRaw;
    private byte[] endingAddressRaw;
    private byte[] extendedStartingAddressRaw;
    private byte[] extendedEndingAddressRaw;

    public SmbiosType20(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        this.startingAddressRaw = this.nextBYTES(4);
        this.endingAddressRaw = this.nextBYTES(4);
        byte[] memoryDeviceHandleRaw = this.nextBYTES(2);
        byte[] memoryArrayMappedAddressHandleRaw = this.nextBYTES(2);
        byte partitionRowPositionRaw = this.nextBYTE();
        byte interleavePositionRaw = this.nextBYTE();
        byte interleavedDataDepthRaw = this.nextBYTE();
        this.extendedStartingAddressRaw = this.nextBYTES(8);
        this.extendedEndingAddressRaw = this.nextBYTES(8);
        this.startingAddress = this.getByteString(this.startingAddressRaw);
        this.endingAddress = this.getByteString(this.endingAddressRaw);
        this.memoryDeviceHandle = this.getByteString(memoryDeviceHandleRaw);
        this.memoryArrayMappedAddressHandle = this.getByteString(memoryArrayMappedAddressHandleRaw);
        this.partitionRowPosition = this.getByteString(new byte[]{partitionRowPositionRaw});
        this.interleavePosition = this.getByteString(new byte[]{interleavePositionRaw});
        this.interleavedDataDepth = this.getByteString(new byte[]{interleavedDataDepthRaw});
        this.extendedStartingAddress = this.getByteString(this.extendedStartingAddressRaw);
        this.extendedEndingAddress = this.getByteString(this.extendedEndingAddressRaw);
        this.rangeSize = this.parseRangeSize();
    }

    private String parseRangeSize() {
        long start = GbtCommonConverters.ByteArraytoLong(this.startingAddressRaw);
        long end = GbtCommonConverters.ByteArraytoLong(this.endingAddressRaw);
        long result = (end - start + 1L) / 1024L / 1024L;
        if (start == 0xFFFFFFFFL && end == 0xFFFFFFFFL) {
            start = GbtCommonConverters.ByteArraytoLong(this.extendedStartingAddressRaw);
            end = GbtCommonConverters.ByteArraytoLong(this.extendedEndingAddressRaw);
            result = (end - start + 1L) / 1024L / 1024L / 1024L;
        }
        return Long.toString(result);
    }

    @JsonProperty(value="StartingAddress")
    public String getStartingAddress() {
        return this.startingAddress;
    }

    @JsonProperty(value="EndingAddress")
    public String getEndingAddress() {
        return this.endingAddress;
    }

    @JsonProperty(value="MemoryDeviceHandle")
    public String getMemoryDeviceHandle() {
        return this.memoryDeviceHandle;
    }

    @JsonProperty(value="MemoryArrayMappedAddressHandle")
    public String getMemoryArrayMappedAddressHandle() {
        return this.memoryArrayMappedAddressHandle;
    }

    @JsonProperty(value="PartitionRowPosition")
    public String getPartitionRowPosition() {
        return this.partitionRowPosition;
    }

    @JsonProperty(value="InterleavePosition")
    public String getInterleavePosition() {
        return this.interleavePosition;
    }

    @JsonProperty(value="InterleavedDataDepth")
    public String getInterleavedDataDepth() {
        return this.interleavedDataDepth;
    }

    @JsonProperty(value="ExtendedStartingAddress")
    public String getExtendedStartingAddress() {
        return this.extendedStartingAddress;
    }

    @JsonProperty(value="ExtendedEndingAddress")
    public String getExtendedEndingAddress() {
        return this.extendedEndingAddress;
    }

    @JsonProperty(value="RangeSize")
    public String getRangeSize() {
        return this.rangeSize;
    }
}

