/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Trap;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Trap.TrapCommand;
import Gbt.utility.Trap.TrapData;
import Gbt.utility.Trap.TrapIpType;

public enum TrapIPMIOptions implements GbtIPMIOptions<TrapCommand.Builder>
{
    GET(0, "get", 2),
    SET(1, "set", 1);

    private static final String GET_ITEM = "get";
    private static final String SET_ITEM = "set";
    private static final byte LAN_CHANNEL_NUMBER = 1;
    private static final byte LAN_PARAMETER_SELECTOR = 19;
    private final int optionCode;
    private final String item;
    private static final byte NET_FN = 12;
    private static final byte SET_CMD = 1;
    private static final byte GET_CMD = 2;
    private final byte commandCode;

    private TrapIPMIOptions(int optionCode, String item, byte commandCode) {
        this.optionCode = optionCode;
        this.item = item;
        this.commandCode = commandCode;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 12;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    public byte[] rebuildRequestData(TrapCommand.Builder commandArgs) {
        switch (this) {
            case GET: {
                byte destSelector = (byte)(commandArgs.getDestinationID() & 0xFF);
                byte blockSeletor = 0;
                return new byte[]{1, 19, destSelector, blockSeletor};
            }
            case SET: {
                TrapData data = commandArgs.getTrapData();
                byte dest = (byte)(data.getDestination_id() & 0xFF);
                if (data.getIp_type() == TrapIpType.IPv4) {
                    byte[] addressBytes = data.getDestination_ip_bytes();
                    byte[] macBytes = new byte[]{0, 0, 0, 0, 0, 0};
                    byte[] trapReqData = new byte[15];
                    trapReqData[0] = 1;
                    trapReqData[1] = 19;
                    trapReqData[2] = dest;
                    trapReqData[3] = 0;
                    trapReqData[4] = 0;
                    System.arraycopy(addressBytes, 0, trapReqData, 5, addressBytes.length);
                    System.arraycopy(macBytes, 0, trapReqData, 9, macBytes.length);
                    return trapReqData;
                }
                if (data.getIp_type() != TrapIpType.IPv6) break;
                byte[] addressBytes = data.getDestination_ip_bytes();
                byte[] trapReqData = new byte[20];
                trapReqData[0] = 1;
                trapReqData[1] = 19;
                trapReqData[2] = dest;
                trapReqData[3] = 16;
                System.arraycopy(addressBytes, 0, trapReqData, 4, addressBytes.length);
                return trapReqData;
            }
        }
        return new byte[0];
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        TrapData data = new TrapData();
        switch (this) {
            case GET: {
                byte[] resp = gbtResponseData.getAllResponseData();
                data.setDestination_id(resp[1]);
                if (resp[2] == 0) {
                    byte[] rawIP = new byte[4];
                    System.arraycopy(resp, 4, rawIP, 0, rawIP.length);
                    data.setIp_type(TrapIpType.IPv4);
                    data.setDestination_ip(GbtCommonConverters.bytesToIPv4Address(rawIP));
                } else {
                    byte[] rawIP = new byte[16];
                    System.arraycopy(resp, 3, rawIP, 0, rawIP.length);
                    data.setIp_type(TrapIpType.IPv6);
                    data.setDestination_ip(GbtCommonConverters.bytesToIPv6Address(rawIP));
                }
                return data;
            }
            case SET: {
                return new NullJSONData().setMessages("Set trap destination IP success.").setError(false);
            }
        }
        return data;
    }
}

