/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.Y23;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import com.jcraft.jsch.Session;
import java.io.File;

public final class UpdateY23CBCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "y23update";
    private static final String DEFAULT_USERNAME = "root";
    private static final String DEFAULT_PASSWORD = "0penBmc";
    private volatile GbtSSHCommandReceiver sshReceiver;
    private volatile GbtLocalCommandReceiver localReceiver;

    protected UpdateY23CBCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.sshReceiver = GbtSSHCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Check arguments fail.");
            return false;
        }
        if (this.sshReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "SSH receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Local command receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        Session session;
        SSHCmdRecords records;
        if (((Builder)this.commandArgs).bmcIP == null) {
            ((Builder)this.commandArgs).bmcIP = this.localReceiver.findDHCPIPbyMAC(((Builder)this.commandArgs).mac, COMMAND_NAME, this.commandID);
        }
        if ((records = this.sendSSHRequest(session = this.sshReceiver.openSession(((Builder)this.commandArgs).bmcIP, DEFAULT_USERNAME, DEFAULT_PASSWORD, COMMAND_NAME, this.commandID), "cat /etc/openrack-board")).getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        String boardLoc = records.getResults().replace("\n", "");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Start update " + boardLoc);
        records = this.sendSSHRequest(session, "/sbin/fw_setenv openbmconce copy-files-to-ram copy-base-filesystem-to-ram");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sendSSHRequest(session, "/sbin/fw_printenv");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "/sbin/reboot");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        session = ((Builder)this.commandArgs).mac != null ? this.sshReceiver.waitBootCompleteByMac(((Builder)this.commandArgs).mac, DEFAULT_USERNAME, DEFAULT_PASSWORD, 200, COMMAND_NAME, this.commandID) : this.sshReceiver.waitBootComplete(((Builder)this.commandArgs).bmcIP, DEFAULT_USERNAME, DEFAULT_PASSWORD, 200, COMMAND_NAME, this.commandID);
        records = this.sendSSHRequest(session, "/sbin/fw_printenv");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "cat /etc/os-release");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sshReceiver.scp(session, ((Builder)this.commandArgs).image_initramfs, "/run/initramfs", COMMAND_NAME, this.commandID);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sshReceiver.scp(session, ((Builder)this.commandArgs).image_kernel, "/run/initramfs", COMMAND_NAME, this.commandID);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sshReceiver.scp(session, ((Builder)this.commandArgs).image_rofs, "/run/initramfs", COMMAND_NAME, this.commandID);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "ls /run/initramfs");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "ln -s /usr/sbin/flashcp /usr/bin/flashcp");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sendSSHRequest(session, "ln -s /sbin/blkid /usr/bin/blkid");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sendSSHRequest(session, "ln -s /sbin/fw_setenv /usr/bin/fw_setenv");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sendSSHRequest(session, "ln -s /sbin/fw_printenv /usr/bin/fw_printenv");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        records = this.sendSSHRequest(session, "/run/initramfs/update");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "/sbin/reboot");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        session = ((Builder)this.commandArgs).mac != null ? this.sshReceiver.waitBootCompleteByMac(((Builder)this.commandArgs).mac, DEFAULT_USERNAME, DEFAULT_PASSWORD, 200, COMMAND_NAME, this.commandID) : this.sshReceiver.waitBootComplete(((Builder)this.commandArgs).bmcIP, DEFAULT_USERNAME, DEFAULT_PASSWORD, 200, COMMAND_NAME, this.commandID);
        records = this.sendSSHRequest(session, "cat /etc/version");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "New FW version : " + records.getResults());
        records = this.sendSSHRequest(session, "cat /etc/os-release");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "New FW version : " + records.getResults());
        records = this.sendSSHRequest(session, "cat /proc/mtd");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        if (!records.getResults().contains("mtd7")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Cannot find SPI2 flash chip.");
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        records = this.sshReceiver.scp(session, ((Builder)this.commandArgs).spi2, "/run/initramfs", COMMAND_NAME, this.commandID);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "ls /run/initramfs");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, boardLoc + " start update SPI2 flash chip.");
        records = this.sendSSHRequest(session, "/usr/sbin/flashcp -v /run/initramfs/" + ((Builder)this.commandArgs).spi2Name + " /dev/mtd7");
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getResults());
        records = this.sendSSHRequest(session, "rm /run/initramfs/" + ((Builder)this.commandArgs).spi2Name);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
            return false;
        }
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, boardLoc + " all chips update complete.");
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private SSHCmdRecords sendSSHRequest(Session session, String cmd) {
        SSHCmdRecords records = this.sshReceiver.executeCMD(session, cmd, false, COMMAND_NAME, this.commandID);
        if (records.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "SSH command : (" + cmd + ") fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Records ID : " + records.getRecordsID());
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return records;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "SSH command : (" + cmd + ") success.");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Records ID : " + records.getRecordsID());
        return records;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String mac;
        private File updFW;
        private File image_kernel;
        private File image_initramfs;
        private File image_rofs;
        private File spi2;
        private String path = "";
        private String spi2Name = "";

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length != 3) {
                    return false;
                }
                this.setBMCMAC(this.args[0]);
                this.setUpdateFW(this.args[1]);
                this.setUpdateSPI2FW(this.args[2]);
            }
            if (this.mac == null && this.bmcIP == null) {
                return false;
            }
            if (this.updFW != null) {
                if (!this.updFW.exists()) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.spi2 != null) {
                return this.spi2.exists();
            }
            return false;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public UpdateY23CBCommand build() {
            return new UpdateY23CBCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCMAC(String mac) {
            this.mac = mac;
            return this.getThis();
        }

        public Builder setUpdateFW(String srcPath) {
            this.updFW = new File(srcPath);
            this.path = srcPath;
            this.image_kernel = new File(srcPath + "image-kernel");
            this.image_initramfs = new File(srcPath + "image-initramfs");
            this.image_rofs = new File(srcPath + "image-rofs");
            return this.getThis();
        }

        public Builder setUpdateSPI2FW(String srcPath) {
            this.spi2Name = srcPath;
            this.spi2 = new File(this.path + srcPath);
            return this.getThis();
        }
    }
}

