/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;

public final class BmcSuitableFwParser
extends SuitableFwParser {
    private boolean isHpmUpdate = false;

    public BmcSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
    }

    @Override
    public BMCUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<BMCUpdateFWInfo> chosenPkgs = new ArrayList<BMCUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            List<File> relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".docx", true);
            relNotePathList.addAll(CommonFunction.searchFilesInDirector(dirPath, ".pdf", true));
            relNotePathList.addAll(CommonFunction.searchFilesInDirector(dirPath, ".doc", true));
            if (relNotePathList.isEmpty()) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any BMC release notes.");
                return null;
            }
            for (File relNotePath : relNotePathList) {
                try {
                    BMCUpdateFWInfo updateFWInfo = new BMCUpdateFWInfo();
                    updateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
                    updateFWInfo.setTargetBmcIp(this.bmcIpAddress);
                    updateFWInfo.setTargetBMCProductID(mcinfo.getProductID());
                    updateFWInfo.setTargetBMCType(mcinfo.getProductName().toString());
                    updateFWInfo.setUpdateType(UpdateType.BMC);
                    updateFWInfo.setFWFolderPath(dirPath);
                    updateFWInfo.setReleaseNote(relNotePath);
                    List<String> lines = CommonFunction.readDocumentsAsLineList(relNotePath.getAbsolutePath());
                    switch (mcinfo.getProductName()) {
                        case G450CMC: {
                            updateFWInfo.setSupportedProductName(lines.get(1).trim().split("\t")[0].replace(" ", ""));
                            break;
                        }
                        case CMC: {
                            updateFWInfo.setSupportedProductName(lines.get(1).trim().split("\t")[0].replace(" ", ""));
                            break;
                        }
                        case GreenPickCMC: {
                            updateFWInfo.setSupportedProductName(lines.get(1).trim().split("\t")[0].replace(" ", ""));
                            break;
                        }
                        default: {
                            StringBuilder builder;
                            List<String> pnames;
                            List<File> projectTxt;
                            if (relNotePath.getName().contains("_v4")) {
                                projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects128.txt", true);
                                if (projectTxt.isEmpty()) {
                                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects128.txt.");
                                    projectTxt.add(new File("projects128.txt"));
                                }
                                if (!(pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath())).isEmpty()) {
                                    builder = new StringBuilder();
                                    for (String pname : pnames) {
                                        builder.append(pname);
                                    }
                                    updateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                                    builder.setLength(0);
                                    break;
                                }
                                updateFWInfo.setSupportedProductName(lines.get(1).replace(" ", ""));
                                break;
                            }
                            if (relNotePath.getName().contains("_v8")) {
                                projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects256.txt", true);
                                if (projectTxt.isEmpty()) {
                                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects256.txt.");
                                    projectTxt.add(new File("projects256.txt"));
                                }
                                if (!(pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath())).isEmpty()) {
                                    builder = new StringBuilder();
                                    for (String pname : pnames) {
                                        builder.append(pname);
                                    }
                                    updateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                                    builder.setLength(0);
                                    break;
                                }
                                updateFWInfo.setSupportedProductName(lines.get(1).replace(" ", ""));
                                break;
                            }
                            projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects.txt", true);
                            if (projectTxt.isEmpty()) {
                                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects.txt.");
                                projectTxt.add(new File("projects.txt"));
                            }
                            if (!(pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath())).isEmpty()) {
                                builder = new StringBuilder();
                                for (String pname : pnames) {
                                    builder.append(pname);
                                }
                                updateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                                builder.setLength(0);
                                break;
                            }
                            updateFWInfo.setSupportedProductName(lines.get(1).replace(" ", ""));
                        }
                    }
                    String[] infoLine = lines.get(updateFWInfo.getBmcVendor().isAMI() || updateFWInfo.getBmcVendor().isOpenBMC() || updateFWInfo.getBmcVendor().isInsyde() ? 4 : 3).trim().split("\t");
                    updateFWInfo.setCurrentVersion(mcinfo.getFirmwareRevision());
                    updateFWInfo.setNewVersion(infoLine[1].trim().split("NEW:")[1].trim());
                    updateFWInfo.setReleaseDate(infoLine[2].trim());
                    String[] checksumArray = infoLine[3].trim().split(",");
                    String fwExtension = "";
                    fwExtension = updateFWInfo.getBmcVendor().isAMI() || updateFWInfo.getBmcVendor().isOpenBMC() || updateFWInfo.getBmcVendor().isInsyde() ? ".bin" : ".img";
                    String imagePath = this.findBMCFWImgByChecksum(dirPath, fwExtension, checksumArray, updateFWInfo);
                    if (imagePath != null) {
                        if (this.isHpmUpdate) {
                            List<File> tempList = CommonFunction.searchFilesInDirector(dirPath, ".hpm", true);
                            if (!tempList.isEmpty()) {
                                updateFWInfo.setImagePath(tempList.get(0).getAbsolutePath());
                            }
                        } else {
                            updateFWInfo.setImagePath(imagePath);
                        }
                    } else {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Fail with compare checksum!");
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + updateFWInfo.toString());
                        continue;
                    }
                    if (this.compareBMCFWProductName(boardProduct, productName, updateFWInfo, mcinfo)) {
                        chosenPkgs.add(updateFWInfo);
                        continue;
                    }
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any matched product name or board product in release notes : \"" + relNotePath.getName() + "\"");
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + updateFWInfo.toString());
                }
                catch (Exception e) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Parse " + relNotePath.getAbsolutePath() + " fail.");
                }
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable BMC FW.");
            return null;
        }
        long[] longDates = new long[chosenPkgs.size()];
        for (int i = 0; i < chosenPkgs.size(); ++i) {
            longDates[i] = ((BMCUpdateFWInfo)chosenPkgs.get(i)).getReleaseDate().getTime();
        }
        List<Long> b = Arrays.asList(ArrayUtils.toObject((long[])longDates));
        BMCUpdateFWInfo finalOutput = (BMCUpdateFWInfo)chosenPkgs.get(b.indexOf(Collections.max(b)));
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandId, "[" + this.bmcIpAddress + "] Matched release note : " + finalOutput.getReleaseNote().getAbsolutePath());
        return finalOutput;
    }

    private String findBMCFWImgByChecksum(String searchRootPath, String firmwareExtName, String[] checksumArray, BMCUpdateFWInfo updateFWInfo) {
        List<File> imgPath = CommonFunction.searchFilesInDirector(searchRootPath, firmwareExtName, true);
        if (imgPath.isEmpty()) {
            return null;
        }
        for (File anImgPath : imgPath) {
            int imgChecksum = GIGABYTEChecksum.getBMCChecksum(anImgPath.getAbsolutePath());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Checksum of \"" + anImgPath.getAbsolutePath() + "\" is " + imgChecksum);
            for (String aChecksumArray : checksumArray) {
                List<File> tempList;
                int checksum = Integer.parseInt(aChecksumArray.trim(), 16);
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Get the checksum " + checksum + " from release note.");
                if (checksum != imgChecksum) continue;
                updateFWInfo.setChecksum(aChecksumArray);
                if (updateFWInfo.getBmcVendor().isAMI()) {
                    tempList = CommonFunction.searchFilesInDirector(searchRootPath, ".ima_enc", true);
                    if (tempList.isEmpty()) continue;
                    return tempList.get(0).getAbsolutePath();
                }
                if (updateFWInfo.getBmcVendor().isOpenBMC() || updateFWInfo.getBmcVendor().isInsyde()) {
                    tempList = CommonFunction.searchFilesInDirector(searchRootPath, ".tar", true);
                    if (tempList.isEmpty()) continue;
                    return tempList.get(0).getAbsolutePath();
                }
                return anImgPath.getAbsolutePath();
            }
        }
        return null;
    }

    private boolean compareBMCFWProductName(String boardProduct, String productName, BMCUpdateFWInfo bmcUpdFwInfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (bmcUpdFwInfo.getSupportedProductName() == null) {
            return false;
        }
        if (bmcUpdFwInfo.getSupportedProductName().isEmpty()) {
            return false;
        }
        boardProduct = boardProduct.replace(" ", "");
        productName = productName.replace(" ", "");
        String string = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        String _productName = bmcInfoJSONData.isAST2400() ? (productName.split("-").length == 3 ? productName : productName + "-XX") : (productName.split("-").length == 3 ? productName : productName + "-00");
        for (String name : bmcUpdFwInfo.getSupportedProductName()) {
            String _name;
            String string2 = bmcInfoJSONData.isAST2400() ? (name.split("-").length == 3 ? name : name + "-XX") : (_name = name.split("-").length == 3 ? name : name + "-00");
            if (_name.equals(_productName)) {
                return true;
            }
            if (!_name.equals(_boardProduct)) continue;
            return true;
        }
        return false;
    }

    public void isHpmUpdate(boolean isHpmUpdate) {
        this.isHpmUpdate = isHpmUpdate;
    }
}

