/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.ScpUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ScpSuitableFwParser
extends SuitableFwParser {
    public ScpSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
    }

    @Override
    public ScpUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<ScpUpdateFWInfo> chosenPkgs = new ArrayList<ScpUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            List<File> relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".doc", true);
            if (relNotePathList.isEmpty()) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any BMC release notes.");
                return null;
            }
            for (File relNotePath : relNotePathList) {
                try {
                    String imagePath;
                    StringBuilder builder;
                    List<String> pnames;
                    ScpUpdateFWInfo scpUpdateFWInfo = new ScpUpdateFWInfo();
                    scpUpdateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
                    scpUpdateFWInfo.setTargetBmcIp(this.bmcIpAddress);
                    scpUpdateFWInfo.setUpdateType(UpdateType.SCP);
                    scpUpdateFWInfo.setFwFolderPath(dirPath);
                    scpUpdateFWInfo.setReleaseNote(relNotePath);
                    List<String> lines = CommonFunction.readDocumentsAsLineList(relNotePath.getAbsolutePath());
                    List<File> projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects.txt", true);
                    if (projectTxt.isEmpty()) {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects.txt.");
                        projectTxt.add(new File("projects.txt"));
                    }
                    if (!(pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath())).isEmpty()) {
                        builder = new StringBuilder();
                        for (String pname : pnames) {
                            builder.append(pname);
                        }
                    } else {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any support projects in projects.txt!");
                        continue;
                    }
                    scpUpdateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                    builder.setLength(0);
                    String checksumString = "";
                    for (String line : lines) {
                        if (!line.toUpperCase().startsWith("HPM") || !line.toUpperCase().contains("OLD") || !line.toUpperCase().contains("NEW")) continue;
                        checksumString = line.trim().split("\t")[3];
                    }
                    if (checksumString.equals("")) {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Fail with get checksum from release note!");
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + scpUpdateFWInfo.toString());
                        continue;
                    }
                    String fwExtension = ".hpm";
                    List<File> hpmList = CommonFunction.searchFilesInDirector(dirPath, fwExtension, true);
                    if (hpmList != null && hpmList.size() > 0) {
                        scpUpdateFWInfo.setImagePath(hpmList.get(0).getAbsolutePath());
                    }
                    if ((imagePath = this.findSCPFWImgByChecksum(dirPath, fwExtension, checksumString)) == null) {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Fail with compare checksum!");
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + scpUpdateFWInfo.toString());
                        continue;
                    }
                    scpUpdateFWInfo.setImagePath(imagePath);
                    if (this.compareBMCFWProductName(boardProduct, productName, scpUpdateFWInfo, mcinfo)) {
                        chosenPkgs.add(scpUpdateFWInfo);
                        continue;
                    }
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any matched product name or board product in release notes : \"" + relNotePath.getName() + "\"");
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + scpUpdateFWInfo.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Parse " + relNotePath.getAbsolutePath() + " fail.");
                }
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable BMC FW.");
            return null;
        }
        return (ScpUpdateFWInfo)chosenPkgs.get(0);
    }

    private String findSCPFWImgByChecksum(String searchRootPath, String firmwareExtName, String checksum) {
        List<File> imgPath = CommonFunction.searchFilesInDirector(searchRootPath, firmwareExtName, true);
        if (imgPath.isEmpty()) {
            return null;
        }
        for (File anImgPath : imgPath) {
            String imgChecksum = GIGABYTEChecksum.getMD5Checksum(anImgPath.getAbsolutePath());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Checksum of \"" + anImgPath.getAbsolutePath() + "\" is " + imgChecksum);
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Get the checksum " + checksum + " from release note.");
            if (!checksum.equals(imgChecksum)) continue;
            return anImgPath.getAbsolutePath();
        }
        return null;
    }

    private boolean compareBMCFWProductName(String boardProduct, String productName, ScpUpdateFWInfo ScpUpdFwInfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (ScpUpdFwInfo.getSupportedProductName() == null) {
            return false;
        }
        if (ScpUpdFwInfo.getSupportedProductName().isEmpty()) {
            return false;
        }
        boardProduct = boardProduct.replace(" ", "");
        productName = productName.replace(" ", "");
        String string = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        String _productName = bmcInfoJSONData.isAST2400() ? (productName.split("-").length == 3 ? productName : productName + "-XX") : (productName.split("-").length == 3 ? productName : productName + "-00");
        for (String name : ScpUpdFwInfo.getSupportedProductName()) {
            String _name;
            String string2 = bmcInfoJSONData.isAST2400() ? (name.split("-").length == 3 ? name : name + "-XX") : (_name = name.split("-").length == 3 ? name : name + "-00");
            if (_name.equals(_productName)) {
                return true;
            }
            if (!_name.equals(_boardProduct)) continue;
            return true;
        }
        return false;
    }
}

