/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcwebutils;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCPlatform;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bmcinfo.BmcDeviceIpmiOptions;
import Gbt.utility.bmcwebutils.PhantomJSOptions;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;

public final class BMCUtilCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "bmcutil";
    private final GbtLocalCommandReceiver localReceiver;
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected BMCUtilCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        AbstractJSONPOJO mcinfo = this.ipmiReceiver.sendIPMIRawCommand(handle, BmcDeviceIpmiOptions.GETDEVICEID, null, COMMAND_NAME, this.commandID);
        if (!(mcinfo instanceof BMCInfoJSONData)) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCPlatform platform = mcinfo.castConcreteJSON(BMCInfoJSONData.class).getProductName();
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] platform : " + platform.toString() + " .");
        File bmcWebUtil = new File(((Builder)this.commandArgs).bmcUtilsPath);
        if (!bmcWebUtil.exists() && !this.localReceiver.checkBMCUtilPkg(COMMAND_NAME, this.commandID)) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        ((Builder)this.commandArgs).isX64 = this.localReceiver.detectOSArchitecture(COMMAND_NAME, this.commandID);
        NullJSONData respD = new NullJSONData();
        this.commandResults.add(respD);
        LocalCmdRecords records = null;
        switch (((Builder)this.commandArgs).option) {
            case 0: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.Reboot, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("is rebooting...")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 1: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.Dump, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Download Crash Image Complete!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 2: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.Backup, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Download Backup File Complete!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 3: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.Restore, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Restore Configuration Finish")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 4: {
                BMCPlatform platform2 = mcinfo.castConcreteJSON(BMCInfoJSONData.class).getProductName();
                switch (platform2) {
                    case CMC: {
                        records = this.localReceiver.executeLocalCommand(PhantomJSOptions.PHYInfo, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                        if (records.getStates().isPass()) {
                            if (records.getResults().contains("Download PHY information JSON file Complete!!")) break;
                            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                            return false;
                        }
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    case GreenPickCMC: {
                        records = this.localReceiver.executeLocalCommand(PhantomJSOptions.PHYInfo, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                        if (records.getStates().isPass()) {
                            if (records.getResults().contains("Download PHY information JSON file Complete!!")) break;
                            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                            return false;
                        }
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    case G450CMC: {
                        records = this.localReceiver.executeLocalCommand(PhantomJSOptions.PHYInfo, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                        if (records.getStates().isPass()) {
                            if (records.getResults().contains("Download PHY information JSON file Complete!!")) break;
                            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                            return false;
                        }
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    default: {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support BMC.");
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                }
            }
            case 5: {
                GbtIpmiCommandResponseData resp = this.ipmiReceiver.sendRawRequest(handle, (byte)46, (byte)80, new byte[]{10, 60, 0, -124, 1}, COMMAND_NAME, this.commandID);
                if (resp == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.BIOSexport, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (!records.getResults().contains("Download File Complete!!")) {
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                } else {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
                if (handle == null) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
                    return false;
                }
                resp = this.ipmiReceiver.sendRawRequest(handle, (byte)46, (byte)80, new byte[]{10, 60, 0, -124, 0}, COMMAND_NAME, this.commandID);
                if (resp != null) break;
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 6: {
                GbtIpmiCommandResponseData respu = this.ipmiReceiver.sendRawRequest(handle, (byte)46, (byte)80, new byte[]{10, 60, 0, -124, 1}, COMMAND_NAME, this.commandID);
                if (respu == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.BIOSimport, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (!records.getResults().contains("Upload Complete!!")) {
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                } else {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
                if (handle == null) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
                    return false;
                }
                respu = this.ipmiReceiver.sendRawRequest(handle, (byte)46, (byte)80, new byte[]{10, 60, 0, -124, 0}, COMMAND_NAME, this.commandID);
                if (respu != null) break;
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 7: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.GetSmartHDD, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Download File Complete!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 8: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.UploadCAFile, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("CA upload Configuration success!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 9: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.UploadFanProfile, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Fan profile upload Configuration success!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 10: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.ShowFanProfile, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Show up Fan profile success!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case 11: {
                records = this.localReceiver.executeLocalCommand(PhantomJSOptions.RunFanProfile, this.commandArgs, GbtLogLevel.INFO, COMMAND_NAME, this.commandID);
                if (records.getStates().isPass()) {
                    if (records.getResults().contains("Run Fan profile " + ((Builder)this.commandArgs).fanProfileName + " success!!")) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, records.getErrors());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            default: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Unknown phantom JS option.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        respD.setError(false).setMessages(records.getResults());
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private int option = 0;
        protected boolean isX64 = true;
        protected String bmcIP;
        protected String bmcUsername = "admin";
        protected String bmcPassword = "password";
        protected File path;
        protected String fanProfileName;
        protected String bmcUtilsPath = CommonFunction.isWindows() ? "bmcWebUtils" : "bmcWebUtils";

        @Override
        public boolean checkArgs() {
            block56: {
                block55: {
                    if (this.bmcIP == null) {
                        return false;
                    }
                    if (this.args == null) break block55;
                    if (this.args.length < 1) {
                        return false;
                    }
                    switch (this.args[0]) {
                        case "reboot": {
                            if (this.args.length != 1) {
                                return false;
                            }
                            this.option = 0;
                            break;
                        }
                        case "prtsc": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 1;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "backup": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 2;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "restore": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 3;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "phyinfo": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 4;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "bsexport": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 5;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "bsimport": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 6;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "getsmarthdd": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 7;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "caupload": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 8;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "fanprofile": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 9;
                            this.setFilePath(new File(this.args[1]));
                            if (this.path == null || !this.path.exists()) {
                                return false;
                            }
                            break block56;
                        }
                        case "showfanprofile": {
                            if (this.args.length != 1) {
                                return false;
                            }
                            this.option = 10;
                            break;
                        }
                        case "runfanprofile": {
                            if (this.args.length != 2) {
                                return false;
                            }
                            this.option = 11;
                            this.setFanProfileName(this.args[1]);
                            if (this.fanProfileName == null || this.getThis().fanProfileName.equals("")) {
                                return false;
                            }
                            break block56;
                        }
                        default: {
                            return false;
                        }
                    }
                    break block56;
                }
                switch (this.option) {
                    case 0: {
                        break;
                    }
                    default: {
                        if (this.path != null) break;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public BMCUtilCommand build() {
            return new BMCUtilCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.option = 0;
            this.isX64 = true;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.path = null;
            this.loggerWriter.close();
        }

        public Builder setOption(PhantomJSOptions option) {
            this.option = option.getOptionCode();
            return this.getThis();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setFilePath(File path) {
            this.path = path;
            return this.getThis();
        }

        public Builder setBmcUtilsDirPath(String path) {
            this.bmcUtilsPath = path;
            return this.getThis();
        }

        public Builder setFanProfileName(String fanProfileName) {
            this.fanProfileName = fanProfileName;
            return this.getThis();
        }
    }
}

