/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.imageChecksum;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.firmwareBackup.CommandSupportStatus;
import Gbt.utility.firmwareBackup.DumpImageChecksumIpmiOptions;
import Gbt.utility.firmwareBackup.FirmwareBackupStatus;
import Gbt.utility.firmwareBackup.FirmwareBackupStatusIpmiOptions;
import Gbt.utility.firmwareBackup.ImageChecksumIpmiOptions;
import Gbt.utility.firmwareBackup.ImageChecksumResult;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.math.BigInteger;
import java.util.List;

public class ImageChecksumCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "imagechecksum";
    private static final int CHECKSUM_WAIT_COUNT = 480;
    private GbtIPMICommandReceiver ipmiReceiver;

    protected ImageChecksumCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get checksum.");
        List<AbstractJSONPOJO> commandResults = this.ipmiReceiver.sendGbtOEMCommand(handle, DumpImageChecksumIpmiOptions.DUMP_CALCULATE_BIOS1, this.commandArgs, COMMAND_NAME, this.commandID);
        this.commandResults.addAll(commandResults);
        for (AbstractJSONPOJO resp : commandResults) {
            if (resp instanceof NullJSONData) {
                NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Dump image checksum fail!");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waitting 15 secs for BMC to start dumpimg checksum...");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!(resp instanceof CommandSupportStatus)) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unexcepted response.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            CommandSupportStatus supportStatus = resp.castConcreteJSON(CommandSupportStatus.class);
            if (!supportStatus.getSupport().booleanValue()) {
                this.commandResults.add(new NullJSONData().setMessages("Action is not support.").setError(false));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Action is not support.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return true;
            }
            if (supportStatus.getSuccess().booleanValue()) continue;
            this.commandResults.add(new NullJSONData().setMessages("Dump image command is fail!").setError(false));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Dump image command is fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        int count = 0;
        boolean calstatus = false;
        while (count < 480) {
            MainUpdateCommand.Builder builder = new MainUpdateCommand.Builder();
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, FirmwareBackupStatusIpmiOptions.GET_STATUS, builder, COMMAND_NAME, this.commandID);
            if (resp instanceof FirmwareBackupStatus) {
                FirmwareBackupStatus status = resp.castConcreteJSON(FirmwareBackupStatus.class);
                if (status.getProgress() != null && status.getProgress().intValue() > 0) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Calculating checksum : " + status.getProgress() + "%");
                } else {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + status.getStatus());
                }
                if (status.getResult() != null) {
                    calstatus = status.getResult();
                    break;
                }
            }
            ++count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count >= 480) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Backup process is timeout!");
        }
        if (!calstatus) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Calculate checksum fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.commandResults.add(new NullJSONData().setMessages("Calculate checksum fail!").setError(true));
            return false;
        }
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ImageChecksumIpmiOptions.GET_CHECKSUM_BIOS1, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof ImageChecksumResult) {
            BigInteger checksumFromImage = GIGABYTEChecksum.getBIOSAreaChecksum(((Builder)this.commandArgs).imagePath);
            ImageChecksumResult commandResult = resp.castConcreteJSON(ImageChecksumResult.class);
            if (checksumFromImage == null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Caculate image checksum fail!");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setMessages("Caculate image checksum fail!").setError(true));
                this.commandResults.add(commandResult);
                return false;
            }
            if (commandResult.getCheckusm() == null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Checksum is different!");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setMessages("Checksum is different!").setError(true));
                this.commandResults.add(commandResult);
                return false;
            }
            byte[] checksumArray = new byte[commandResult.getCheckusm().length + 1];
            checksumArray[0] = 0;
            System.arraycopy(commandResult.getCheckusm(), 0, checksumArray, 1, commandResult.getCheckusm().length);
            BigInteger checksumFromBMC = new BigInteger(checksumArray);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Checksum from BMC : " + checksumFromBMC.toString(16));
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Checksum from image : " + checksumFromImage.toString(16));
            if (!checksumFromImage.equals(checksumFromBMC)) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Checksum is different!");
                this.commandResults.add(new NullJSONData().setMessages("Checksum is different!").setError(false));
                this.commandResults.add(commandResult);
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Checksum is the same.");
            this.commandResults.add(new NullJSONData().setMessages("Checksum is the same.").setError(false));
            this.commandResults.add(commandResult);
        } else {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(temp);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String imagePath;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null && this.args.length > 0) {
                this.imagePath = this.args[0];
            }
            if (this.imagePath == null) {
                return false;
            }
            File image = new File(this.imagePath);
            return image.exists();
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public ImageChecksumCommand build() {
            return new ImageChecksumCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setImagePath(String imagePath) {
            this.imagePath = imagePath;
            return this.getThis();
        }
    }
}

