/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.menu;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.CommandTask;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.receivers.SolCommandReceiver;
import Gbt.utility.Chassis.ChassisPowerCommand;
import Gbt.utility.ConfigSave.ConfigSaveCommand;
import Gbt.utility.Configdeploy.ConfigDeployCommand;
import Gbt.utility.FRU.FRUType;
import Gbt.utility.FRU.GetFRUCommand;
import Gbt.utility.GPUFanPolicy.GetGPUFanPolicyCommand;
import Gbt.utility.HDDInfo.HwInfoCommand;
import Gbt.utility.HpmUpdate.HpmPreUpdateCommand;
import Gbt.utility.HpmUpdate.HpmUpdateCommand;
import Gbt.utility.IKVM.LaunchiKVMCommand;
import Gbt.utility.IPSrc.IPSrcCommand;
import Gbt.utility.IPv6Config.IPv6ConfigCommand;
import Gbt.utility.Identify.IdentifyCommand;
import Gbt.utility.LoadDefault.LoadDefaultCommand;
import Gbt.utility.Local.LocalSubCommand;
import Gbt.utility.LogoChange.LogoChangeCommand;
import Gbt.utility.MSR.MSRCommand;
import Gbt.utility.MultiNode.GetMultiNodeCommand;
import Gbt.utility.NTP.NtpCommand;
import Gbt.utility.OSdeploy.OSDeployCommand;
import Gbt.utility.PEF.PEFCommand;
import Gbt.utility.RAW.IPMIRawCommand;
import Gbt.utility.SDR.SDRCommand;
import Gbt.utility.SEL.SELCommand;
import Gbt.utility.SMB.SMBCommand;
import Gbt.utility.SMBIOS.GetSMBIOSCommand;
import Gbt.utility.SMTP.SMTPCommand;
import Gbt.utility.Trap.TrapCommand;
import Gbt.utility.UnlockUpdateStatus.UnlockUpdateStatusCommand;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.PreUpdateCommand;
import Gbt.utility.Update.Y23.UpdateY23CBCommand;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BmcResetCommand;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmcwebutils.BMCUtilCommand;
import Gbt.utility.bootoptions.SetBootOptionCommand;
import Gbt.utility.diag.DiagCommand;
import Gbt.utility.fwlist.FwListCommand;
import Gbt.utility.imageActiveStatus.ImageActiveStatusCommand;
import Gbt.utility.imageChecksum.ImageChecksumCommand;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.menu.ParserArgument;
import Gbt.utility.meversion.MeVersionCommand;
import Gbt.utility.networkconfig.BMCNetworkConfigCommand;
import Gbt.utility.postcode.PostCodeCommand;
import Gbt.utility.power.GetPowerReadingCommand;
import Gbt.utility.power.PowerLimitCommand;
import Gbt.utility.redfish.RedfishCommand;
import Gbt.utility.rest.RestCommand;
import Gbt.utility.scan.ScanCommand;
import Gbt.utility.sol.SolCommand;
import Gbt.utility.sol.SolDeactivateEventListener;
import Gbt.utility.solcmd.SolCmdCommand;
import Gbt.utility.solconfig.SolConfigCommand;
import Gbt.utility.useraccounts.UserAccountCommand;
import Gbt.utility.vmclitool.VmcliCommand;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;

public final class GbtUtility {
    private static final SimpleDateFormat STD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat STD_FORMAT_LOG = new SimpleDateFormat("HH-mm-ss");
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "password";
    public static String additionalLogTime = "";
    private static volatile List<AbstractCommandReceiver> receivers;
    private static final String MENU_LOG_PATH = "menu";
    private static AbstractLoggerWriter loggerWriter;

    private GbtUtility() {
    }

    public static final void main(String[] args) {
        String commandName;
        loggerWriter = new DefaultLoggerWriter(GbtUtility.class);
        GbtUtility.logoPrettyPrinter();
        ParserArgument parserArg = new ParserArgument(args);
        if (!parserArg.checkArgs()) {
            GbtUtility.printMenu();
            try {
                loggerWriter.close();
            }
            catch (Exception e) {
                loggerWriter = null;
            }
            System.exit(1);
        }
        if (!parserArg.parserOptions(commandName = parserArg.getCommandName())) {
            parserArg.printOptionHelp("java -jar GbtUtility-${project.version}.jar <options> <command> [arguments]");
            GbtUtility.printMenu();
            try {
                loggerWriter.close();
            }
            catch (Exception e) {
                loggerWriter = null;
            }
            System.exit(1);
        }
        GbtUtility.loadReceivers();
        if (parserArg.getLogSaveTag()) {
            additionalLogTime = "_" + STD_FORMAT_LOG.format(new Date());
        }
        switch (commandName) {
            case "scan": {
                ScanCommand scan = ((ScanCommand.Builder)new ScanCommand.Builder().setUsername(parserArg.getBMCUsername()).setPassword(parserArg.getBMCPassword()).setCommandLineArgs(parserArg.getRestArgument())).build();
                if (!scan.checkAll()) {
                    GbtUtility.printMenu(commandName);
                    try {
                        scan.close();
                        parserArg = null;
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    System.exit(1);
                }
                if (!scan.execute()) {
                    GbtUtility.printMenu(commandName);
                    try {
                        scan.close();
                        parserArg = null;
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    System.exit(1);
                }
                try {
                    scan.close();
                    parserArg = null;
                    loggerWriter.close();
                }
                catch (Exception e) {
                    GbtIPMIConnector.disconnect();
                    loggerWriter = null;
                    System.exit(1);
                }
                break;
            }
            case "update": {
                if (GbtUtility.updateExecutes(parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRestArgument())) break;
                GbtIPMIConnector.disconnect();
                GbtUtility.unloadReceivers();
                try {
                    loggerWriter.close();
                }
                catch (Exception e) {
                    loggerWriter = null;
                }
                System.exit(1);
                break;
            }
            case "hpmupdate": {
                if (GbtUtility.hpmUpdateExecutes(parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRestArgument())) break;
                GbtIPMIConnector.disconnect();
                GbtUtility.unloadReceivers();
                try {
                    loggerWriter.close();
                }
                catch (Exception e) {
                    loggerWriter = null;
                }
                System.exit(1);
                break;
            }
            case "rest": {
                List<AbstractCommand<?>> restCmdList = GbtUtility.normalCommandList(commandName, parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRedfishUsername(), parserArg.getRedfishPassword(), parserArg.getRestArgument());
                if (restCmdList.isEmpty()) {
                    GbtUtility.printMenu(commandName);
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    restCmdList.clear();
                    restCmdList = null;
                    System.exit(1);
                }
                if (!GbtUtility.normalExecutes(restCmdList)) {
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    restCmdList.clear();
                    restCmdList = null;
                    System.exit(1);
                }
                if (parserArg.getRestArgument()[0].equals("vmedia")) {
                    String ans;
                    Scanner scanner = new Scanner(System.in);
                    System.out.println();
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Quit vmedia please enter \"Q\" or \"q\" **");
                    while (!(ans = scanner.nextLine()).toUpperCase().equals("Q")) {
                    }
                    for (AbstractCommand<?> command : restCmdList) {
                        command.cancelHook("Q");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    scanner.close();
                }
                restCmdList.clear();
                restCmdList = null;
                break;
            }
            case "sol": {
                Object restCmdList;
                List<AbstractCommand<?>> solCmdList = GbtUtility.normalCommandList(commandName, parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRedfishUsername(), parserArg.getRedfishPassword(), parserArg.getRestArgument());
                if (solCmdList.isEmpty()) {
                    GbtUtility.printMenu(commandName);
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    solCmdList.clear();
                    restCmdList = null;
                    System.exit(1);
                }
                if (!GbtUtility.normalExecutes(solCmdList)) {
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    solCmdList.clear();
                    restCmdList = null;
                    System.exit(1);
                }
                if (!parserArg.getRestArgument()[0].equalsIgnoreCase("activate") || !GbtUtility.needSOLWaiting(parserArg.getRestArgument())) break;
                System.out.println();
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Quit SOL please enter \"~.\" **");
                boolean keep = true;
                while (keep) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String ans = null;
                    boolean isAllSOLDeactivate = false;
                    try {
                        while (!br.ready() && !isAllSOLDeactivate) {
                            isAllSOLDeactivate = GbtUtility.checkIsAllSOLDeactivate(solCmdList);
                            Thread.sleep(500L);
                        }
                        if (br.ready() && !isAllSOLDeactivate) {
                            ans = br.readLine();
                        }
                    }
                    catch (InterruptedException e) {
                        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "ConsoleInputReadTask() cancelled");
                        keep = false;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        keep = false;
                    }
                    if (!isAllSOLDeactivate) {
                        for (AbstractCommand<?> command : solCmdList) {
                            if (!(command instanceof SolCommand)) continue;
                            if (ans.toUpperCase().equals("~.")) {
                                ((SolCommand)command).terminateSOL();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                keep = false;
                                try {
                                    command.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            ((SolCommand)command).sendConsolInput(ans);
                        }
                    } else {
                        keep = false;
                    }
                    if (keep) continue;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            default: {
                List<AbstractCommand<?>> commandList = GbtUtility.normalCommandList(commandName, parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRedfishUsername(), parserArg.getRedfishPassword(), parserArg.getRestArgument());
                if (commandList.isEmpty()) {
                    GbtUtility.printMenu(commandName);
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    commandList.clear();
                    commandList = null;
                    System.exit(1);
                }
                if (!GbtUtility.normalExecutes(commandList)) {
                    GbtIPMIConnector.disconnect();
                    GbtUtility.unloadReceivers();
                    try {
                        loggerWriter.close();
                    }
                    catch (Exception e) {
                        loggerWriter = null;
                    }
                    commandList.clear();
                    commandList = null;
                    System.exit(1);
                }
                commandList.clear();
                commandList = null;
            }
        }
        GbtIPMIConnector.disconnect();
        GbtUtility.unloadReceivers();
        try {
            loggerWriter.close();
            System.exit(0);
        }
        catch (Exception e) {
            loggerWriter = null;
            System.exit(1);
        }
    }

    public static final String getResultsRootPath() {
        return "results/" + STD_FORMAT.format(new Date());
    }

    private static final void logoPrettyPrinter() {
        Properties props = new Properties();
        String GBTUTILITY_VERSION = null;
        String projectName = null;
        try {
            props.load(GbtUtility.class.getResourceAsStream("/properties/gbtutil.properties"));
            projectName = props.getProperty("gbtutil.name");
            GBTUTILITY_VERSION = props.getProperty("gbtutil.version");
        }
        catch (IOException ioe) {
            projectName = "CLI";
            GBTUTILITY_VERSION = "";
        }
        String logo = String.format("%-5s ", "*") + String.format("%-15s", "GIGABYTE(TM) " + projectName + " v") + String.format("%-" + (GBTUTILITY_VERSION.length() + 5) + "s", GBTUTILITY_VERSION) + "*";
        StringBuilder lineBuilder = new StringBuilder();
        for (int i = 0; i < logo.length(); ++i) {
            lineBuilder.append("*");
        }
        String logoline = lineBuilder.toString();
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logoline);
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logo);
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logoline);
        lineBuilder.setLength(0);
    }

    private static void loadReceivers() {
        receivers = new ArrayList<AbstractCommandReceiver>();
        receivers.add(GbtIPMICommandReceiver.getInstance());
        receivers.add(GbtLocalCommandReceiver.getInstance());
        receivers.add(GbtSSHCommandReceiver.getInstance());
        receivers.add(RESTClientReceiver.getInstance());
        receivers.add(SolCommandReceiver.getInstance());
    }

    private static void unloadReceivers() {
        for (AbstractCommandReceiver receiver : receivers) {
            receiver.closeReceivers();
        }
        receivers.clear();
    }

    private static final List<AbstractCommand<?>> normalCommandList(String commandName, String[] bmcIPAddresses, String bmcUsername, String bmcPassword, String redfishUsername, String redfishPassword, String[] restArgs) {
        ArrayList commands = new ArrayList();
        switch (commandName) {
            case "chassis": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((ChassisPowerCommand.Builder)new ChassisPowerCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "limit": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((PowerLimitCommand.Builder)new PowerLimitCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "boot": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SetBootOptionCommand.Builder)new SetBootOptionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "trap": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((TrapCommand.Builder)new TrapCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "pef": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((PEFCommand.Builder)new PEFCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "ipv6": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((IPv6ConfigCommand.Builder)new IPv6ConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "power": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetPowerReadingCommand.Builder)new GetPowerReadingCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "sel": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SELCommand.Builder)new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "fru": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetFRUCommand.Builder)new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setFRUType(FRUType.FRU).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "sdr": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SDRCommand.Builder)new SDRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "msr": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((MSRCommand.Builder)new MSRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "ipsrc": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((IPSrcCommand.Builder)new IPSrcCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "hwinfo": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((HwInfoCommand.Builder)new HwInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "logochange": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((LogoChangeCommand.Builder)new LogoChangeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "smbios": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetSMBIOSCommand.Builder)new GetSMBIOSCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "loaddf": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((LoadDefaultCommand.Builder)new LoadDefaultCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "multinode": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetMultiNodeCommand.Builder)new GetMultiNodeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "local": {
                commands.add(((LocalSubCommand.Builder)new LocalSubCommand.Builder().setCommandLineArgs(restArgs)).build());
                return commands;
            }
            case "ikvm": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((LaunchiKVMCommand.Builder)new LaunchiKVMCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "identify": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((IdentifyCommand.Builder)new IdentifyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "mcinfo": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetBMCInfoCommand.Builder)new GetBMCInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "raw": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((IPMIRawCommand.Builder)new IPMIRawCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "userapp": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((UserAccountCommand.Builder)new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "vmcli": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((VmcliCommand.Builder)new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "ntp": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((NtpCommand.Builder)new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "bmcutil": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((BMCUtilCommand.Builder)new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "mac": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetMACListCommand.Builder)new GetMACListCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "redfish": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((RedfishCommand.Builder)new RedfishCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setRedfishUsername(redfishUsername).setRedfishPassword(redfishPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "gpufan": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetGPUFanPolicyCommand.Builder)new GetGPUFanPolicyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "osdeploy": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((OSDeployCommand.Builder)new OSDeployCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "smtp": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SMTPCommand.Builder)new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "bpinfo": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetFRUCommand.Builder)new GetFRUCommand.Builder().setBMCIP(bmcIP).setFRUType(FRUType.BPB).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "psuinfo": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((GetFRUCommand.Builder)new GetFRUCommand.Builder().setBMCIP(bmcIP).setFRUType(FRUType.PSU).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "rest": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((RestCommand.Builder)new RestCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "y23update": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((UpdateY23CBCommand.Builder)new UpdateY23CBCommand.Builder().setBMCIP(bmcIP).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "configdeploy": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((ConfigDeployCommand.Builder)new ConfigDeployCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "configsave": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((ConfigSaveCommand.Builder)new ConfigSaveCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "diag": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((DiagCommand.Builder)new DiagCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "postcode": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((PostCodeCommand.Builder)new PostCodeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "meversion": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((MeVersionCommand.Builder)new MeVersionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "lanprint": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((BMCLanConfigCommand.Builder)new BMCLanConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "unlockkk": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((UnlockUpdateStatusCommand.Builder)new UnlockUpdateStatusCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "netconfig": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((BMCNetworkConfigCommand.Builder)new BMCNetworkConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "mcreset": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((BmcResetCommand.Builder)new BmcResetCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "solconfig": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SolConfigCommand.Builder)new SolConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
            }
            case "solcmd": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SolCmdCommand.Builder)new SolCmdCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "sol": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SolCommand.Builder)new SolCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "fwlist": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((FwListCommand.Builder)new FwListCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "imagechecksum": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((ImageChecksumCommand.Builder)new ImageChecksumCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "smb": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((SMBCommand.Builder)new SMBCommand.Builder().setSmbUser(bmcUsername).setSmbPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
            case "imageactivestatus": {
                for (String bmcIP : bmcIPAddresses) {
                    commands.add(((ImageActiveStatusCommand.Builder)new ImageActiveStatusCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build());
                }
                return commands;
            }
        }
        return commands;
    }

    private static final boolean normalExecutes(List<AbstractCommand<?>> commandList) {
        boolean allCheckOK = true;
        for (AbstractCommand<?> command : commandList) {
            if (command.checkAll()) continue;
            try {
                allCheckOK = false;
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!allCheckOK) {
            GbtUtility.printMenu(commandList.get(0));
            commandList.clear();
            commandList = null;
            return false;
        }
        int poolSize = Runtime.getRuntime().availableProcessors() * 3;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(commandList.get(0).getCommandName())).setThreadNumber(commandList.size() < poolSize ? commandList.size() : poolSize)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (AbstractCommand<?> command : commandList) {
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (!taskManager.executeTasks()) {
            try {
                GbtUtility.printMenu(commandList.get(0));
                taskManager.close();
                taskManager = null;
                factory = null;
                commandList.clear();
                commandList = null;
            }
            catch (Exception e) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
            }
            return false;
        }
        boolean allSuccess = GbtUtility.executionSummary(commandList.get(0).getCommandName(), commandList.size(), taskManager.getAllResults());
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
            return allSuccess;
        }
        catch (Exception e) {
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
            return false;
        }
    }

    private static final boolean updateExecutes(String[] bmcIPAddresses, String bmcUsername, String bmcPassword, String[] restArgs) {
        int poolSize = Runtime.getRuntime().availableProcessors() * 3;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("preupdate")).setThreadNumber(bmcIPAddresses.length < poolSize ? bmcIPAddresses.length : poolSize)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String bmcIPAddress : bmcIPAddresses) {
            PreUpdateCommand command = ((PreUpdateCommand.Builder)new PreUpdateCommand.Builder().setBMCIP(bmcIPAddress).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build();
            if (!command.checkAll()) {
                try {
                    GbtUtility.printMenu("update");
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
            }
            return false;
        }
        ArrayList<MainUpdateCommand> updateCommands = new ArrayList<MainUpdateCommand>();
        boolean waitAns = false;
        boolean backImg = false;
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (!records.getStates().isPass()) continue;
            ++success;
            AbstractJSONPOJO fwInfo = null;
            BMCInfoJSONData bmcInfo = null;
            for (AbstractJSONPOJO result : records.getCommand(PreUpdateCommand.class).getCommandResults()) {
                if (result instanceof BMCInfoJSONData) {
                    bmcInfo = result.castConcreteJSON(BMCInfoJSONData.class);
                    continue;
                }
                fwInfo = result;
            }
            if (!records.getCommand(PreUpdateCommand.class).isContinue()) {
                waitAns = true;
            }
            if (records.getCommand(PreUpdateCommand.class).isBackupimg()) {
                backImg = true;
            }
            updateCommands.add(((MainUpdateCommand.Builder)new MainUpdateCommand.Builder().setCommandLineArgs(restArgs)).setPreUpdateFWInfo(fwInfo).setBmcInfoJSONData(bmcInfo).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).build());
        }
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), "\nFind suitable FW total success nodes : " + success + "\t fail nodes : " + (bmcIPAddresses.length - success));
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
        }
        catch (Exception e) {
            return false;
        }
        if (success == 0) {
            return false;
        }
        if (waitAns) {
            String ans;
            Iterator<String> scanner = new Scanner(System.in);
            System.out.println();
            if (backImg) {
                GbtUtility.printBackupImgWarningMessage();
                ans = ((Scanner)scanner).nextLine();
                if (!ans.toUpperCase().equals("Y")) {
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Cancel update process. **");
                    ((Scanner)scanner).close();
                    return true;
                }
            }
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Do you want to continue update the success nodes of preupdate (Y/N) ? **");
            ans = ((Scanner)scanner).nextLine();
            if (!ans.toUpperCase().equals("Y")) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Cancel update process. **");
                ((Scanner)scanner).close();
                return true;
            }
            ((Scanner)scanner).close();
        }
        factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("update")).setThreadNumber(updateCommands.size() < poolSize ? updateCommands.size() : poolSize)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        taskManager = new DefaultTaskManager(factory);
        for (MainUpdateCommand command : updateCommands) {
            if (!command.checkAll()) {
                GbtUtility.printMenu("update");
                try {
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                return false;
            }
        }
        GbtUtility.executionSummary(((MainUpdateCommand)updateCommands.get(0)).getCommandName(), updateCommands.size(), taskManager.getAllResults());
        try {
            taskManager.close();
            updateCommands.clear();
            taskManager = null;
            factory = null;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean hpmUpdateExecutes(String[] bmcIPAddresses, String bmcUsername, String bmcPassword, String[] restArgs) {
        int poolSize = Runtime.getRuntime().availableProcessors() * 3;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("hpmpreupdate")).setThreadNumber(bmcIPAddresses.length < poolSize ? bmcIPAddresses.length : poolSize)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String bmcIPAddress : bmcIPAddresses) {
            HpmPreUpdateCommand hpmPreUpdateCommand = ((HpmPreUpdateCommand.Builder)new HpmPreUpdateCommand.Builder().setBMCIP(bmcIPAddress).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(restArgs)).build();
            if (!hpmPreUpdateCommand.checkAll()) {
                try {
                    GbtUtility.printMenu("hpmupdate");
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(hpmPreUpdateCommand));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
            }
            return false;
        }
        ArrayList<HpmUpdateCommand> updateCommands = new ArrayList<HpmUpdateCommand>();
        boolean waitAns = false;
        int success = 0;
        for (String string : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(string)).castSubRecords(CommandTaskRecords.class);
            if (!records.getStates().isPass()) continue;
            ++success;
            AbstractJSONPOJO info = records.getCommand(HpmPreUpdateCommand.class).getCommandResults().get(0);
            if (!records.getCommand(HpmPreUpdateCommand.class).isContinue()) {
                waitAns = true;
            }
            updateCommands.add(((HpmUpdateCommand.Builder)new HpmUpdateCommand.Builder().setCommandLineArgs(restArgs)).setPreUpdateFWInfo(info).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).build());
        }
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), "\nFind suitable FW total success nodes : " + success + "\t fail nodes : " + (bmcIPAddresses.length - success));
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
        }
        catch (Exception e) {
            return false;
        }
        if (success == 0) {
            return false;
        }
        if (waitAns) {
            Iterator<String> scanner = new Scanner(System.in);
            System.out.println();
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Do you want to continue update the success nodes of preupdate (Y/N) ? **");
            String string = ((Scanner)scanner).nextLine();
            if (!string.toUpperCase().equals("Y")) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), "** Cancel hpm update process. **");
                ((Scanner)scanner).close();
                return true;
            }
            ((Scanner)scanner).close();
        }
        factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("update")).setThreadNumber(updateCommands.size() < poolSize ? updateCommands.size() : poolSize)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        taskManager = new DefaultTaskManager(factory);
        for (HpmUpdateCommand hpmUpdateCommand : updateCommands) {
            if (!hpmUpdateCommand.checkAll()) {
                GbtUtility.printMenu("hpmupdate");
                try {
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(hpmUpdateCommand));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Resources close error." + e.getMessage());
                return false;
            }
        }
        GbtUtility.executionSummary(((HpmUpdateCommand)updateCommands.get(0)).getCommandName(), updateCommands.size(), taskManager.getAllResults());
        try {
            taskManager.close();
            updateCommands.clear();
            taskManager = null;
            factory = null;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean executionSummary(String commandName, int totalMembers, Map<String, CommandTaskRecords> taskResults) {
        String logo = "*       GIGABYTE(TM) CLI \"" + commandName + "\" Command Executions Summary       *";
        StringBuilder lineBuilder = new StringBuilder();
        for (int i = 0; i < logo.length(); ++i) {
            lineBuilder.append("*");
        }
        String logoline = lineBuilder.toString();
        boolean allSuccess = true;
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logoline);
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logo);
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logoline);
        int success = 0;
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), String.format("%-15s | ", "Target IP:") + String.format("%-13s | ", "Command Name:") + String.format("%-7s | ", "Status:") + "Total elapsed times:");
        for (String taskID : taskResults.keySet()) {
            CommandTaskRecords records = taskResults.get(taskID);
            allSuccess &= records.getStates().isPass();
            if (records.getStates().isPass()) {
                loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), String.format("%-15s | ", records.getTargetIP()) + String.format("%-13s | ", records.getCommandName()) + String.format("%-7s | ", "Success") + records.getFinalElapsedTimes());
                ++success;
                continue;
            }
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), String.format("%-15s | ", records.getTargetIP()) + String.format("%-13s | ", records.getCommandName()) + String.format("%-7s | ", "Fail") + records.getFinalElapsedTimes());
        }
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.INFO, GbtUtility.class.getSimpleName(), "Total success nodes : " + success + "\t fail nodes : " + (totalMembers - success));
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), logoline);
        return allSuccess;
    }

    private static final void printMenu() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(GbtUtility.class.getResourceAsStream("/GbtReadme.txt")));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            boolean lock = false;
            while (line != null) {
                line = br.readLine();
                if (line.contains("Chapter 3")) {
                    lock = true;
                }
                if (lock && !line.contains("Chapter 3") && !line.contains("Chapter 3-1")) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                }
                if (!line.contains("Chapter 3-1")) continue;
                lock = false;
                break;
            }
            br.close();
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), sb.toString());
            sb.setLength(0);
        }
        catch (Exception e) {
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Cannot read or not found the GbtReadme.txt");
        }
    }

    private static final void printMenu(String commandName) {
        InputStream inputStream = GbtUtility.class.getResourceAsStream("/docs/" + commandName + ".txt");
        if (inputStream == null) {
            GbtUtility.printMenu();
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append(System.lineSeparator());
                line = br.readLine();
            }
            br.close();
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), sb.toString());
            sb.setLength(0);
        }
        catch (Exception e) {
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Cannot read or not found the /docs/" + commandName + ".txt");
        }
    }

    private static final void printMenu(AbstractCommand command) {
        InputStream inputStream = GbtUtility.class.getResourceAsStream("/docs/" + command.getDocumentsName() + ".txt");
        if (inputStream == null) {
            GbtUtility.printMenu(command.getCommandName());
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append(System.lineSeparator());
                line = br.readLine();
            }
            br.close();
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), sb.toString());
            sb.setLength(0);
        }
        catch (Exception e) {
            loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.ERROR, GbtUtility.class.getSimpleName(), "Cannot read or not found the /docs/" + command.getDocumentsName() + ".txt");
        }
    }

    private static final boolean needSOLWaiting(String[] args) {
        for (String s : args) {
            if (!s.startsWith("cmdfile=")) continue;
            return false;
        }
        return true;
    }

    private static final boolean checkIsAllSOLDeactivate(List<AbstractCommand<?>> commandList) {
        boolean isAllSOLDeactivate = true;
        Iterator<AbstractCommand<?>> commandIterator = commandList.iterator();
        while (commandIterator.hasNext()) {
            SolCommand solCommand = (SolCommand)commandIterator.next();
            SolEventListener listener = solCommand.getSolEventListener();
            if (!(listener instanceof SolDeactivateEventListener)) continue;
            if (((SolDeactivateEventListener)listener).isTerminate()) {
                solCommand.terminateSOL();
                commandIterator.remove();
                continue;
            }
            isAllSOLDeactivate = false;
        }
        return isAllSOLDeactivate;
    }

    private static final void printBackupImgWarningMessage() {
        StringBuilder warnMessage = new StringBuilder();
        warnMessage.append("*******************************************************\n");
        warnMessage.append("   __   __   __     ____      ______       __      __  \n");
        warnMessage.append("  /_/  /_/  /_/  __/_/_/_    /_/_/_/      /_/     /_/  \n");
        warnMessage.append("  /_/  /_/ /_/  /_/   /_/   /_/___/_/    /_/_/   /_/   \n");
        warnMessage.append("  /_/ /_/ /_/  /_/_/_/_/   /_/_/_/      /_/ /_/ /_/    \n");
        warnMessage.append("  /_/_/ /_/   /_/   /_/   /_/   /_/    /_/   /_/_/     \n");
        warnMessage.append("   /_/ /_/   /_/   /_/   /_/     /_/  /_/     /_/      \n\n");
        warnMessage.append("*******************************************************\n");
        warnMessage.append("  You have selected update backup image mode !!\n");
        warnMessage.append("  If update backup image process fail or break by accident, it may cause system crash.\n");
        warnMessage.append("  Are you sure yo continue? (Y/N)");
        loggerWriter.appendPath(MENU_LOG_PATH).writeLogs(GbtLogLevel.DEBUG, GbtUtility.class.getSimpleName(), warnMessage.toString());
    }
}

