/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;
import Gbt.utility.redfish.options.LogServiceLocation;

public enum LogServiceApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1"),
    LIST("/LogServices"),
    GET("/LogServices"),
    MODIFY("/LogServices"),
    LOG("/LogServices/<id>/Entries"),
    CLEAR("/LogServices/<id>/Actions/LogService.ClearLog");

    private static final String UNKNOWN_URI = "/redfish/v1";
    private static final String LIST_URI = "/LogServices";
    private static final String GET_URI = "/LogServices";
    private static final String MODIFY_URI = "/LogServices";
    private static final String LOGS_URI = "/LogServices/<id>/Entries";
    private static final String CLEAR_URI = "/LogServices/<id>/Actions/LogService.ClearLog";
    private final String mainUri;

    private LogServiceApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case GET: {
                return "The log service ID is not assigned.";
            }
            case MODIFY: {
                return "The log service ID is not assigned.";
            }
            case LOG: {
                return "The log service ID is not assigned.";
            }
            case CLEAR: {
                return "The log service ID is not assigned.";
            }
        }
        return "Unsupport option of log service API.";
    }

    public String getFullUri(LogServiceLocation mainLoc, String mainLocId, String logId) {
        switch (this) {
            case LIST: {
                return mainLoc.getRootUri() + "/" + mainLocId + this.getMainUri();
            }
            case GET: {
                return mainLoc.getRootUri() + "/" + mainLocId + this.getMainUri() + "/" + logId;
            }
            case MODIFY: {
                return mainLoc.getRootUri() + "/" + mainLocId + this.getMainUri() + "/" + logId;
            }
            case LOG: {
                return mainLoc.getRootUri() + "/" + mainLocId + this.getMainUri().replace("<id>", logId);
            }
            case CLEAR: {
                return mainLoc.getRootUri() + "/" + mainLocId + this.getMainUri().replace("<id>", logId);
            }
        }
        return this.getMainUri();
    }

    public static final LogServiceApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return LogServiceApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

