/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;
import Gbt.core.rest.RESTHttpMethods;

public enum RedfishRawOptions implements RedfishApiOptions
{
    Unsupport(RESTHttpMethods.Unsupport),
    GET(RESTHttpMethods.GET),
    POST(RESTHttpMethods.POST),
    PATCH(RESTHttpMethods.PATCH),
    DELETE(RESTHttpMethods.DELETE);

    private static final String ROOT_URI = "/redfish/v1";
    private final RESTHttpMethods method;

    private RedfishRawOptions(RESTHttpMethods method) {
        this.method = method;
    }

    @Override
    public String getOptionName() {
        return this.method.toString();
    }

    @Override
    public String getMainUri() {
        return ROOT_URI;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case GET: {
                return "Missing target URI.";
            }
            case POST: {
                return "Missing target URI or payload json data.";
            }
            case PATCH: {
                return "Missing target URI or payload json data.";
            }
            case DELETE: {
                return "Missing target URI.";
            }
        }
        return "The unsupport HTTP method of Redfish raw API option.";
    }

    public RESTHttpMethods getMethod() {
        return this.method;
    }

    public boolean isUnsupport() {
        return this.method == RESTHttpMethods.Unsupport;
    }

    public static final RedfishRawOptions parse(String rawString) {
        switch (RESTHttpMethods.parse(rawString)) {
            case GET: {
                return GET;
            }
            case POST: {
                return POST;
            }
            case PATCH: {
                return PATCH;
            }
            case DELETE: {
                return DELETE;
            }
        }
        return Unsupport;
    }
}

