/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.RedfishRawOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class RedfishRawApi
extends RedfishApiService<PayLoad> {
    protected RedfishRawApi(PayLoad servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.RAW.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((PayLoad)this.servicePayload).getRestRawArgs().length < 2) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((PayLoad)this.servicePayload).setServiceOption(RedfishRawOptions.parse(((PayLoad)this.servicePayload).getRestRawArgs()[0]));
        switch ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case GET: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((PayLoad)this.servicePayload).setResourceURI(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                return true;
            }
            case POST: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 3) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((PayLoad)this.servicePayload).setResourceURI(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[2]));
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case PATCH: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 3) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((PayLoad)this.servicePayload).setResourceURI(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[2]));
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case DELETE: {
                switch (((PayLoad)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((PayLoad)this.servicePayload).setResourceURI(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                        return true;
                    }
                    case 3: {
                        ((PayLoad)this.servicePayload).setResourceURI(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                        ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case GET: {
                if (((PayLoad)this.servicePayload).getResourceURI() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return true;
            }
            case POST: {
                if (((PayLoad)this.servicePayload).getResourceURI() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case PATCH: {
                if (((PayLoad)this.servicePayload).getResourceURI() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case DELETE: {
                if (((PayLoad)this.servicePayload).getResourceURI() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    return true;
                }
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((PayLoad)this.servicePayload).getUsername(), ((PayLoad)this.servicePayload).getPassword(), ((PayLoad)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        RESTRequestImpl.Builder requestBuilder = null;
        if (((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getMethod() == RESTHttpMethods.PATCH) {
            String etag = this.getETag(((PayLoad)this.servicePayload).getProtocolHeader(), client, ((PayLoad)this.servicePayload).getResourceURI());
            requestBuilder = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setContentType("application/json")).setHeaders("If-Match", etag)).setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getMethod())).setServiceURI(((PayLoad)this.servicePayload).getResourceURI());
        } else {
            requestBuilder = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setContentType("application/json")).setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getMethod())).setServiceURI(((PayLoad)this.servicePayload).getResourceURI());
        }
        switch ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case POST: {
                requestBuilder.setRawJsonData(this.requestBody);
                break;
            }
            case PATCH: {
                requestBuilder.setRawJsonData(this.requestBody);
                break;
            }
            case DELETE: {
                if (this.requestBody == null) break;
                requestBuilder.setRawJsonData(this.requestBody);
                break;
            }
            case Unsupport: {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RedfishRawOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                client.close();
                return false;
            }
        }
        try {
            Response response = this.restReceiver.syncInvoke(client, ((RESTRequest.Builder)requestBuilder).build(), "redfish", this.serviceLogsId);
            RestFullResponseData desResponse = this.restReceiver.deserializeAsCommonData(response);
            this.responseData.add(desResponse);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResponse.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResponse.getResponseBody()));
            boolean bl = !desResponse.isRedfishErrorResponse();
            return bl;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
            if (re.getUnexpectedBody() != null) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            client.close();
        }
    }

    public static final class PayLoad
    extends RedfishApiPayload<PayLoad, RedfishRawOptions> {
        private String resourceURI;

        public PayLoad(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(RedfishRawOptions.Unsupport);
        }

        public PayLoad(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(RedfishRawOptions.Unsupport);
        }

        @Override
        protected PayLoad getThis() {
            return this;
        }

        public RedfishRawApi build() {
            return new RedfishRawApi(this);
        }

        public PayLoad setResourceURI(String resourceURI) {
            this.resourceURI = resourceURI;
            return this.getThis();
        }

        public String getResourceURI() {
            return this.resourceURI;
        }
    }
}

