/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.models.ami.update.UpdateProgressInfo;
import Gbt.utility.redfish.options.UpdateServiceApiOptions;
import Gbt.utility.rest.models.common.RestCustomJsonFormData;
import Gbt.utility.rest.models.update.UpdateServiceOemParameters;
import Gbt.utility.rest.models.update.UpdateServiceParameters;
import Gbt.utility.rest.options.UpdateServiceOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public final class AMIRedfishUpdateService
extends RESTServices {
    public static final String SERVICE_NAME = "amiredfishupdate";
    private static final int MAX_RETRY_COUNT = 30;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 20000;
    private static final String FW_UPLOAD_URI = "/redfish/v1/UpdateService/upload";
    private static final String FW_STATUS_URI = "/redfish/v1/UpdateService";
    private static final String SCM_TARGET_URI = "/redfish/v1/UpdateService/FirmwareInventory/SCM_CPLD1";
    private static final String SCM_IMAGE_TYPE = "SCM_CPLD";
    private static final String UPDATE_FILE_KEY = "UpdateFile";
    private static final String UPDATE_PARA_KEY = "UpdateParameters";
    private static final String OEM_PARA_KEY = "OemParameters";
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    private CommonUpdateFWInfo updateFWInfo;

    public AMIRedfishUpdateService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    public AMIRedfishUpdateService(AbstractLoggerWriter loggerWriter, int connectionTimeout, int readTimeout) {
        super(loggerWriter);
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        if (!(restServicesOptions instanceof UpdateServiceOptions)) {
            return false;
        }
        UpdateServiceOptions options = (UpdateServiceOptions)restServicesOptions;
        switch (options) {
            case CPLDSCM: {
                if (!(jsonData instanceof CPLDUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(CPLDUpdateFWInfo.class);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + restServicesOptions.getOptionName();
        Object response = null;
        boolean retry = false;
        if (!this.uploadFwFile(ipAddress, logName)) {
            return false;
        }
        if (!this.getUpdateStatus(ipAddress, logName)) {
            return false;
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Update complete.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFwFile(String ipAddress, String logName) {
        RestCustomJsonFormData paraData = new RestCustomJsonFormData();
        UpdateServiceParameters para = new UpdateServiceParameters();
        para.addTargets(SCM_TARGET_URI);
        paraData.setContent(para);
        paraData.setMediaType(MediaType.APPLICATION_JSON_TYPE);
        RestCustomJsonFormData oemData = new RestCustomJsonFormData();
        UpdateServiceOemParameters oemPara = new UpdateServiceOemParameters();
        oemPara.setImageType(SCM_IMAGE_TYPE);
        oemData.setContent(oemPara);
        oemData.setMediaType(MediaType.APPLICATION_JSON_TYPE);
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(FW_UPLOAD_URI).setHttpMethods(RESTHttpMethods.POST)).setFormData(UPDATE_FILE_KEY, new File(this.updateFWInfo.getImagePath()))).setFormData(UPDATE_PARA_KEY, paraData)).setFormData(OEM_PARA_KEY, oemData)).setContentType("multipart/form-data")).build();
        Response response = null;
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.client, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for uploading FW image......");
                Thread.sleep(4000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt upload image firmware.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt upload image firmware."));
                boolean bl = false;
                return bl;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        try {
            response = responseFuture.get();
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.CREATED.getStatusCode() && response.getStatus() != Response.Status.ACCEPTED.getStatusCode()) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware fail : " + response.getStatusInfo().getReasonPhrase() + "(" + response.getStatus() + ")");
                boolean ie = false;
                return ie;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload firmware success. (" + response.getStatus() + ")");
            Thread.sleep(3000L);
        }
        catch (InterruptedException | CancellationException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Upload firmware interrupted, " + ie.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException ee) {
            ee.printStackTrace();
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware fail, " + ee.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUpdateStatus(String ipAddress, String logName) {
        int retry = 0;
        Response up_response = null;
        RestFullResponseData up_desResp = null;
        while (retry < 30) {
            try {
                RESTRequestImpl up_request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(ipAddress)).setProtocolHeader(RESTProtocolHeaders.HTTPS)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(UpdateServiceApiOptions.PROGRESS.getMainUri()).setContentType("application/json")).build();
                up_response = this.clientReceiver.syncInvoke(this.client, up_request, this.logDirPath, logName);
                up_desResp = this.clientReceiver.deserializeAsCommonData(up_response);
                Thread.sleep(3000L);
            }
            catch (RESTException re) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + re.getMessage());
                ++retry;
                continue;
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + ie.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (up_response == null) continue;
                up_response.close();
                continue;
            }
            if (up_desResp.isRedfishErrorResponse()) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + up_desResp.toString());
                ++retry;
                continue;
            }
            try {
                UpdateProgressInfo updateProgressInfo = JacksonCommonUtil.getUtil().jsonNodeToPojo(up_desResp.getResponseBody().get("Oem").get("AMIUpdateService").get("UpdateInformation"), UpdateProgressInfo.class);
                if (updateProgressInfo.getFlashPercentage() != null && updateProgressInfo.getUpdateStatus() != null) {
                    if (updateProgressInfo.getFlashPercentage().contains("100%") || updateProgressInfo.getUpdateStatus().toLowerCase().contains("complete")) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target: " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                        break;
                    }
                    if (updateProgressInfo.getUpdateStatus().toLowerCase().contains("flash") && updateProgressInfo.getFlashPercentage().toLowerCase().contains("complete")) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target: " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                        break;
                    }
                    if (updateProgressInfo.getUpdateStatus().toLowerCase().contains("fail")) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Target: " + updateProgressInfo.getUpdateTarget() + ", " + updateProgressInfo.getUpdateStatus() + " " + updateProgressInfo.getFlashPercentage());
                        return false;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target: " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                    retry = 0;
                    continue;
                }
                if (updateProgressInfo.getUpdateStatus() == null || updateProgressInfo.getUpdateStatus().equals("")) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Wait for update progress refresh complete.");
                    Thread.sleep(1000L);
                    ++retry;
                    continue;
                }
                if (updateProgressInfo.getUpdateStatus().toLowerCase().contains("fail")) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target: " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                    return false;
                }
                if (updateProgressInfo.getUpdateStatus().toLowerCase().contains("complete")) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target : " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                    break;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Target : " + updateProgressInfo.getUpdateTarget() + ", Status: " + updateProgressInfo.getUpdateStatus() + ", Percentage: " + updateProgressInfo.getFlashPercentage());
                retry = 0;
            }
            catch (JsonProcessingException je) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + je.getMessage());
                ++retry;
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + ie.getMessage());
                return false;
            }
        }
        return retry != 30;
    }

    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + this.updateFWInfo.getUpdateType().toString();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean closeSession(String ipAddress) {
        if (this.client != null) {
            this.sessionData = null;
            this.client.close();
        }
        return true;
    }
}

