/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.redfish.RestFullResponseData;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.Response;

public final class MultinodeService
extends RESTServices {
    public static final String SERVICE_NAME = "multinode";
    private static final String URL = "/api/oem/multinode";

    public MultinodeService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(URL).setContentType("application/json")).setCookies(this.sessionData)).build();
        try {
            Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            RestFullResponseData finalData = this.clientReceiver.deserializeAsCommonData(response);
            if (finalData.getHttpStatus() != 200) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get multinode data fail.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get multinode data fail."));
                return false;
            }
            this.jsonResults.add(finalData);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get multinode data success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
            return true;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get multinode data fail.");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get multinode data fail."));
            return false;
        }
    }
}

