/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.OpenBmcRestSessionData;
import Gbt.utility.rest.models.update.RestOpenBmcLoginData;
import Gbt.utility.rest.requests.OpenBmcLoginRequest;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class OpenBmcFirmwareEnumerateService
extends RESTServices {
    public static final String SERVICE_NAME = "openbmcfirmwareenumerate";
    private static final String FW_INFO_URI = "/xyz/openbmc_project/software/enumerate";

    public OpenBmcFirmwareEnumerateService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.getServiceName();
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(FW_INFO_URI).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            System.out.println("Get fw info success.");
            Thread.sleep(2000L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.getServiceName();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, 20000, 300000, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        OpenBmcLoginRequest request = ((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)new OpenBmcLoginRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/json")).setRawJsonData(new RestOpenBmcLoginData().setData(new String[]{username, password}))).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<OpenBmcRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Login success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }
}

