/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.scan.upnpimpl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.model.types.ServiceId;

public class UUIDServiceID
extends ServiceId {
    private static final String UNKNOWN_NAME = "unknown";
    private static final String UUID_PATTERN = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final Pattern SERVICE_ID_NORMAL_PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:([a-zA-Z_0-9\\-:\\.]{1,64})");
    private static final Pattern SERVICE_ID_BROKEN_PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):service:([a-zA-Z_0-9\\-:\\.]{1,64})");
    private static final Pattern SERVICE_ID_PATTERN_1 = Pattern.compile("uuid:([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})::urn:([a-zA-Z0-9\\-\\.]+):service:([a-zA-Z_0-9\\-:\\.]{1,64})");
    private static final Pattern SERVICE_ID_PATTERN_2 = Pattern.compile("uuid:([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})::urn:([a-zA-Z0-9\\-\\.]+):serviceId:([a-zA-Z_0-9\\-:\\.]{1,64})");
    private final String uuid;

    public UUIDServiceID(String namespace, String id) {
        this(null, namespace, id);
    }

    public UUIDServiceID(String uuid, String namespace, String id) {
        super(namespace, id);
        if (uuid != null && !uuid.matches(UUID_PATTERN)) {
            throw new IllegalArgumentException("Service ID contains illegal UUID characters or format.");
        }
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static final UUIDServiceID valueOf(String s) throws InvalidValueException {
        Matcher matcher = SERVICE_ID_NORMAL_PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            return new UUIDServiceID(matcher.group(1), matcher.group(2));
        }
        matcher = SERVICE_ID_BROKEN_PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            return new UUIDServiceID(matcher.group(1), matcher.group(2));
        }
        matcher = SERVICE_ID_PATTERN_1.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 3) {
            return new UUIDServiceID(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        matcher = SERVICE_ID_PATTERN_2.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 3) {
            return new UUIDServiceID(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        matcher = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:").matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 1) {
            return new UUIDServiceID(matcher.group(1), UNKNOWN_NAME);
        }
        String[] tokens = s.split("[:]");
        if (tokens.length == 4) {
            return new UUIDServiceID(tokens[1], tokens[3]);
        }
        throw new InvalidValueException("Can't parse service ID string : " + s);
    }

    public String toString() {
        if (this.uuid != null) {
            return "uuid:" + this.uuid + "::urn:" + this.getNamespace() + ":service:" + this.getId();
        }
        return "urn:" + this.getNamespace() + ":service:" + this.getId();
    }
}

