/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.sol;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.SolMessageRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.SolCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.sol.SolCmdData;
import Gbt.utility.sol.SolDeactivateEventListener;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.sol.SerialOverLan;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayloadResponseData;
import java.io.File;
import java.util.List;

public class SolCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "sol";
    private GbtIPMICommandReceiver ipmiReceiver;
    private volatile SolCommandReceiver solCommandReceiver;
    private volatile SerialOverLan serialOverLan;
    private volatile SolEventListener solEventListener;

    protected SolCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.solCommandReceiver = SolCommandReceiver.getInstance();
        this.serialOverLan = null;
        this.solEventListener = commandArgs.solEventListener == null ? new SolDeactivateEventListener(COMMAND_NAME, ((Builder)this.commandArgs).bmcIP) : commandArgs.solEventListener;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.solCommandReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        SolCmdData resultData = new SolCmdData();
        if (((Builder)this.commandArgs).cmdFile != null) {
            try {
                this.serialOverLan = this.solCommandReceiver.activateSol(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME);
                this.serialOverLan.registerEventListener(this.solEventListener);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate SOL success.");
            }
            catch (Exception e) {
                this.serialOverLan.unregisterEventListener(this.solEventListener);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate SOL fail.");
                resultData.setResult(false);
                resultData.setWait(false);
                resultData.setMessage("Activate SOL fail.");
                this.commandResults.add(resultData);
                return false;
            }
            List<String> cmdlist = CommonFunction.readFile(((Builder)this.commandArgs).cmdFile);
            for (String cmd : cmdlist) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + cmd);
                boolean result = this.solCommandReceiver.asyncSendCommand(this.serialOverLan, cmd, COMMAND_NAME);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (result) continue;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Send SOL command fail.");
                break;
            }
            try {
                SolMessageRecords records = this.solCommandReceiver.getAsyncCommandRecords(this.serialOverLan);
                int endWait = 0;
                int messageLength = 0;
                while (endWait < ((Builder)this.commandArgs).timeout || ((Builder)this.commandArgs).timeout == 0) {
                    if (messageLength == records.getFullMessages().length()) {
                        ++endWait;
                    } else {
                        messageLength = records.getFullMessages().length();
                        endWait = 0;
                    }
                    if (this.solEventListener instanceof SolDeactivateEventListener && ((SolDeactivateEventListener)this.solEventListener).isTerminate()) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Stop waitting SOL response.");
                        break;
                    }
                    Thread.sleep(1000L);
                }
                SolCommand solCommand = this;
                solCommand.solCommandReceiver.getInstance().deactivateSol(this.serialOverLan, COMMAND_NAME);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate SOL success.");
            }
            catch (Exception e) {
                this.serialOverLan.unregisterEventListener(this.solEventListener);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate SOL fail.");
                return false;
            }
        }
        if (((Builder)this.commandArgs).activate) {
            try {
                this.serialOverLan = this.solCommandReceiver.activateSol(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME);
                this.serialOverLan.registerEventListener(this.solEventListener);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate SOL success.");
                return true;
            }
            catch (Exception e) {
                this.serialOverLan.unregisterEventListener(this.solEventListener);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate SOL fail.");
                return false;
            }
        }
        try {
            ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
            if (handle == null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            SolCommand solCommand = this;
            DeactivatePayloadResponseData responseData = solCommand.solCommandReceiver.getInstance().deactivateSol(handle, COMMAND_NAME);
            if (responseData != null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate command success.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate SOL fail.", e);
            return false;
        }
        if (this.serialOverLan != null) {
            this.serialOverLan.unregisterEventListener(this.solEventListener);
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SOL command success.");
        return true;
    }

    public SolMessageRecords sendConsolInput(String cmd) {
        SolMessageRecords records = null;
        boolean result = this.solCommandReceiver.asyncSendCommand(this.serialOverLan, cmd, COMMAND_NAME);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (result) {
            records = this.solCommandReceiver.getAsyncCommandRecords(this.serialOverLan);
        }
        return records;
    }

    public SolEventListener getSolEventListener() {
        return this.solEventListener;
    }

    public boolean terminateSOL() {
        try {
            SolCommand solCommand = this;
            solCommand.solCommandReceiver.getInstance().deactivateSol(this.serialOverLan, COMMAND_NAME);
            return true;
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate SOL fail.");
            return false;
        }
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        if (((Builder)this.commandArgs).cmdFile != null) {
            ((Builder)this.commandArgs).close();
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private volatile SolEventListener solEventListener = null;
        private boolean activate = false;
        private int timeout = 3;
        private String cmdFile = null;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].startsWith("timeout=")) {
                        try {
                            this.timeout = Integer.parseInt(this.args[i].split("timeout=")[1]);
                        }
                        catch (Exception e) {
                            this.timeout = -1;
                        }
                        continue;
                    }
                    if (this.args[i].startsWith("cmdfile=")) {
                        this.cmdFile = this.args[i].split("cmdfile=")[1];
                        continue;
                    }
                    if (this.args[i].equalsIgnoreCase("activate")) {
                        this.activate = true;
                        continue;
                    }
                    if (this.args[i].equalsIgnoreCase("deactivate")) {
                        this.activate = false;
                        continue;
                    }
                    return false;
                }
            }
            if (this.timeout < 0) {
                return false;
            }
            return this.cmdFile == null || new File(this.cmdFile).exists();
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public AbstractCommand<Builder> build() {
            return new SolCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String bmcUsername) {
            this.bmcUsername = bmcUsername;
            return this.getThis();
        }

        public Builder setBMCPassword(String bmcPassword) {
            this.bmcPassword = bmcPassword;
            return this.getThis();
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this.getThis();
        }

        public Builder setActivate(boolean activate) {
            this.activate = activate;
            return this.getThis();
        }

        public SolEventListener getSolEventListener() {
            return this.solEventListener;
        }

        public void setSolEventListener(SolEventListener solEventListener) {
            this.solEventListener = solEventListener;
        }
    }
}

