/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sel;

import Gbt.utility.SDR.record.ReadingType;
import Gbt.utility.SDR.record.SensorType;
import com.veraxsystems.vxipmi.coding.commands.sel.EventDirection;
import com.veraxsystems.vxipmi.coding.commands.sel.SelRecordType;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.Date;

public class SelRecord {
    private int recordId;
    private SelRecordType recordType;
    private Date timestamp;
    private byte i2cAddr;
    private String i2cIDType;
    private byte i2cChannelNum;
    private byte evmRev;
    private SensorType sensorType;
    private int sensorNumber;
    private EventDirection eventDirection;
    private ReadingType event;
    private byte reading;
    private String additionalDescription;

    public static SelRecord populateSelRecord(byte[] data) {
        SelRecord record = new SelRecord();
        byte[] buffer = new byte[]{data[0], data[1], 0, 0};
        record.setRecordId(TypeConverter.littleEndianByteArrayToInt(buffer));
        record.setRecordType(SelRecordType.parseInt(TypeConverter.byteToInt(data[2])));
        System.arraycopy(data, 3, buffer, 0, 4);
        record.setTimestamp(TypeConverter.decodeDate(TypeConverter.littleEndianByteArrayToInt(buffer)));
        byte i2cAddr = (byte)((data[7] & 0xFFFFFFFE) >> 1);
        record.setI2CAddress(i2cAddr);
        record.setGeneratorIDAddressType(data[7]);
        byte channelNum = (byte)((data[8] & 0xFFFFFFF0) >> 4);
        record.setChannel(channelNum);
        record.setEvMRev(data[9]);
        record.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(data[10])));
        record.setSensorNumber(TypeConverter.byteToInt(data[11]));
        record.setEventDirection(EventDirection.parseInt((TypeConverter.byteToInt(data[12]) & 0x80) >> 7));
        int eventType = TypeConverter.byteToInt(data[12]) & 0x7F;
        int eventOffset = TypeConverter.byteToInt(data[13]) & 0xF;
        record.setEvent(ReadingType.parseInt(record.getSensorType(), eventType, eventOffset));
        record.setReading(data[14]);
        record.setAdditionalDescription(SelRecord.getAdditionalDescription(record.getEvent(), data[13], data[14], data[15]));
        return record;
    }

    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public SelRecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(SelRecordType recordType) {
        this.recordType = recordType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setI2CAddress(byte i2cAddr) {
        this.i2cAddr = i2cAddr;
    }

    public byte getI2CAddress() {
        return this.i2cAddr;
    }

    public void setGeneratorIDAddressType(byte addr) {
        this.i2cIDType = (addr & 1) == 1 ? "System software ID" : "IPMB Slave Address";
    }

    public String getGeneratorIDAddressType() {
        return this.i2cIDType;
    }

    public void setChannel(byte channel) {
        this.i2cChannelNum = channel;
    }

    public byte getChannel() {
        return this.i2cChannelNum;
    }

    public void setEvMRev(byte rev) {
        this.evmRev = rev;
    }

    public byte getEvMRev() {
        return this.evmRev;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(int sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public EventDirection getEventDirection() {
        return this.eventDirection;
    }

    public void setEventDirection(EventDirection eventDirection) {
        this.eventDirection = eventDirection;
    }

    public ReadingType getEvent() {
        return this.event;
    }

    public void setEvent(ReadingType event) {
        this.event = event;
    }

    public byte getReading() {
        return this.reading;
    }

    public void setReading(byte reading) {
        this.reading = reading;
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public void setAdditionalDescription(String additionalDescription) {
        this.additionalDescription = additionalDescription;
    }

    private static String getAdditionalDescription(ReadingType eventType, byte eventData1, byte eventData2, byte eventData3) {
        if (eventType == ReadingType.PciPErr || eventType == ReadingType.PciSErr) {
            return "Bus#" + eventData2 + ", Device#" + ((eventData3 & 0xF8) >> 3) + ", Function#" + (eventData3 & 7);
        }
        if (eventType == ReadingType.CorrectableEcc || eventType == ReadingType.UncorrectableECC || eventType == ReadingType.CorrectableEccOtherCorrectableMemoryErrorLoggingLimitReached) {
            String Channel2 = "Channel " + SelRecord.getChannelCharcter(eventData3);
            String DIMM = " DIMM" + (eventData3 & 7);
            return Channel2 + DIMM;
        }
        return "";
    }

    private static String getChannelCharcter(byte eventData3) {
        String channel = "";
        channel = (eventData3 & 8) == 8 ? channel + (char)(((eventData3 & 0xF0) >> 4) + 81) : channel + (char)(((eventData3 & 0xF0) >> 4) + 65);
        return channel;
    }
}

