/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.protocol.decoder;

import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.sol.SolInboundMessage;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.IpmiDecoder;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpClassOfMessage;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.security.ConfidentialityAlgorithm;
import com.veraxsystems.vxipmi.common.TypeConverter;

public abstract class ProtocolDecoder
implements IpmiDecoder {
    @Deprecated
    protected int decode(RmcpMessage rmcpMessage, IpmiMessage message, int sequenceNumberOffset, int payloadLengthOffset, int payloadLengthLength) {
        if (rmcpMessage.getClassOfMessage() != RmcpClassOfMessage.Ipmi) {
            throw new IllegalArgumentException("This is not an IPMI message");
        }
        byte[] raw = rmcpMessage.getData();
        message.setAuthenticationType(ProtocolDecoder.decodeAuthenticationType(raw[0]));
        message.setSessionSequenceNumber(this.decodeSessionSequenceNumber(raw, sequenceNumberOffset));
        message.setPayloadLength(this.decodePayloadLength(raw, payloadLengthOffset));
        message.setPayload(this.decodePayload(raw, payloadLengthOffset + payloadLengthLength, message.getPayloadLength(), message.getConfidentialityAlgorithm(), PayloadType.Ipmi));
        return payloadLengthOffset + payloadLengthLength + message.getPayloadLength();
    }

    protected static AuthenticationType decodeAuthenticationType(byte authenticationType) {
        authenticationType = (byte)(authenticationType & TypeConverter.intToByte(15));
        return AuthenticationType.parseInt(TypeConverter.byteToInt(authenticationType));
    }

    public static AuthenticationType decodeAuthenticationType(RmcpMessage message) {
        return ProtocolDecoder.decodeAuthenticationType(message.getData()[0]);
    }

    protected static int decodeInt(byte[] rawMessage, int offset) {
        byte[] result = new byte[4];
        System.arraycopy(rawMessage, offset, result, 0, 4);
        return TypeConverter.littleEndianByteArrayToInt(result);
    }

    protected int decodeSessionSequenceNumber(byte[] rawMessage, int offset) {
        return ProtocolDecoder.decodeInt(rawMessage, offset);
    }

    protected static int decodeSessionID(byte[] rawMessage, int offset) {
        return ProtocolDecoder.decodeInt(rawMessage, offset);
    }

    protected abstract int decodePayloadLength(byte[] var1, int var2);

    protected IpmiPayload decodePayload(byte[] rawData, int offset, int length, ConfidentialityAlgorithm confidentialityAlgorithm, PayloadType payloadType) {
        byte[] payload = null;
        if (length > 0) {
            payload = new byte[length];
            System.arraycopy(rawData, offset, payload, 0, length);
            payload = confidentialityAlgorithm.decrypt(payload);
        }
        if (payloadType == PayloadType.Sol || payload.length == 4) {
            return new SolInboundMessage(payload);
        }
        return new IpmiLanResponse(payload);
    }
}

