/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.payload.sol.SolInboundMessage;
import com.veraxsystems.vxipmi.coding.payload.sol.SolStatus;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.queue.MessageQueue;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.events.Sendv20Message;
import com.veraxsystems.vxipmi.sm.states.SessionValid;

public abstract class MessageHandler {
    protected int lastReceivedSequenceNumber = 0;
    protected final MessageQueue messageQueue;
    protected final Connection connection;

    public MessageHandler(Connection connection, int timeout, int minSequenceNumber, int maxSequenceNumber, String queueName) {
        this.messageQueue = new MessageQueue(connection, timeout, minSequenceNumber, maxSequenceNumber, queueName);
        this.connection = connection;
    }

    public abstract int sendMessage(PayloadCoder var1, StateMachine var2, int var3, boolean var4) throws ConnectionException;

    public int retryMessage(int tag, StateMachine stateMachine, int sessionId) throws ConnectionException {
        this.validateSessionState(stateMachine);
        PayloadCoder payloadCoder = this.messageQueue.getMessageFromQueue(tag);
        if (payloadCoder == null) {
            return -1;
        }
        stateMachine.doTransition(new Sendv20Message(payloadCoder, sessionId, tag, this.connection.getNextSessionSequenceNumber()));
        return tag;
    }

    public void handleIncomingMessage(Ipmiv20Message message) {
        int seq = message.getSessionSequenceNumber();
        if (message.getPayload() instanceof SolInboundMessage && ((SolInboundMessage)message.getPayload()).getStatusField().getStatuses().contains((Object)SolStatus.SolDeactivated)) {
            this.handleIncomingMessageInternal(message);
            return;
        }
        if (seq != 0 && (seq > this.lastReceivedSequenceNumber + 15 || seq < this.lastReceivedSequenceNumber - 16)) {
            return;
        }
        if (seq != 0) {
            this.lastReceivedSequenceNumber = seq > this.lastReceivedSequenceNumber ? seq : this.lastReceivedSequenceNumber;
        }
        this.handleIncomingMessageInternal(message);
    }

    public void setTimeout(int timeout) {
        this.messageQueue.setTimeout(timeout);
    }

    public void tearDown() {
        this.messageQueue.tearDown();
    }

    public int getSequenceNumber() {
        return this.messageQueue.getSequenceNumber();
    }

    protected abstract void handleIncomingMessageInternal(Ipmiv20Message var1);

    protected void validateSessionState(StateMachine stateMachine) throws ConnectionException {
        if (stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new ConnectionException(stateMachine.getCurrent());
        }
    }
}

