/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.UnsupportedDataException;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.gena.IncomingEventRequestMessage;
import org.fourthline.cling.model.message.gena.OutgoingEventResponseMessage;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.resource.ServiceEventCallbackResource;
import org.fourthline.cling.protocol.ReceivingSync;
import org.fourthline.cling.transport.RouterException;

public class ReceivingEvent
extends ReceivingSync<StreamRequestMessage, OutgoingEventResponseMessage> {
    private static final Logger log = Logger.getLogger(ReceivingEvent.class.getName());

    public ReceivingEvent(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected OutgoingEventResponseMessage executeSync() throws RouterException {
        ServiceEventCallbackResource resource;
        if (!((StreamRequestMessage)this.getInputMessage()).isContentTypeTextUDA()) {
            log.warning("Received without or with invalid Content-Type: " + this.getInputMessage());
        }
        if ((resource = this.getUpnpService().getRegistry().getResource(ServiceEventCallbackResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
            log.fine("No local resource found: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.NOT_FOUND));
        }
        final IncomingEventRequestMessage requestMessage = new IncomingEventRequestMessage((StreamRequestMessage)this.getInputMessage(), (RemoteService)resource.getModel());
        if (requestMessage.getSubscrptionId() == null) {
            log.fine("Subscription ID missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            log.fine("Missing NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.BAD_REQUEST));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            log.fine("Invalid NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (requestMessage.getSequence() == null) {
            log.fine("Sequence missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        try {
            this.getUpnpService().getConfiguration().getGenaEventProcessor().readBody(requestMessage);
        }
        catch (UnsupportedDataException ex) {
            log.fine("Can't read event message request body, " + ex);
            final RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getRemoteSubscription(requestMessage.getSubscrptionId());
            if (subscription != null) {
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        subscription.invalidMessage(ex);
                    }
                });
            }
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
        }
        final RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getWaitRemoteSubscription(requestMessage.getSubscrptionId());
        if (subscription == null) {
            log.severe("Invalid subscription ID, no active subscription: " + requestMessage);
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                log.fine("Calling active subscription with event state variable values");
                subscription.receive(requestMessage.getSequence(), requestMessage.getStateVariableValues());
            }
        });
        return new OutgoingEventResponseMessage();
    }
}

