var xpath = require('casper').selectXPath;
var casper = require('casper').create({
    webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');
var G_url;
if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true BIOSSetupImport.js IPAddress Username Password StorePath');
    casper.exit(1);
} else {        
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var StorePath = casper.cli.args[3];

    console.log('Connect to ' + url);
    G_url = url;
    casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
    casper.start();

    casper.open(url, {
        method: 'post'
    });
    
    casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 1000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user':        username,
        '#password':    password,
    });

    casper.click('#btnOK');

    casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 2000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
        casper.waitForSelector('#spanLVL1H', FunctionPageLinkClick, FunctionInvalid, 5000);
    });
}

function FunctionPageLinkClick() {
    console.log('Dump BIOS Image And Parse BIOS Setup Menu Data ....');
    StartFunction();
}

function GetParameterByName(url, name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));    
}

var fileurl = null;
var ST1 = null;
function CheckFileUrl(resource) {
    fileurl = resource.url;
    ST1 = GetParameterByName(fileurl, "ST1");
    console.log(ST1);
    if (ST1) {
        console.log(ST1);
        return true;
    }

    return false;
}

function DownloadFileFromUrl() {
    console.log("Download File ...");

    var filename = StorePath + '/SetupDecode-' + casper.cli.args[0] + '.json';
    filename = fs.absolute(filename);
    fileurl = G_url + '/jsondata/Export?type=0&mode=1';
    if (ST1) {
        fileurl += "&ST1=" + ST1;
    }

    fileurl = encodeURI(fileurl);
    console.log(fileurl);

    casper.download(fileurl, filename);
    console.log("Download File Complete!!");

}

function StartFunction() {
    casper.page.switchToMainFrame();
    casper.wait(20000, function(){        
        casper.waitForResource(CheckFileUrl, DownloadFileFromUrl, FileInvalid, 120000);

    });
}

function LogInTimeOut() {
    console.log('Open ' + url + ' fail!');
    casper.exit(1);
}

function LogInFail() {
    console.log('LogIn ' + url + ' fail!');
    casper.exit(1);
}

function FunctionInvalid() {
    console.log('Export BIOS Setup Menu Data Function Invalid!');
    casper.exit(1);
}

function FileInvalid() {
    console.log('Export BIOS Setup Menu Data Fail, Invalid File!!');
    casper.exit(1);
}

function TimeOut() {
    console.log('Export BIOS Setup Menu Data TimeOut!!');
    casper.exit(1);
}

casper.run();
