var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true RestoreConfigurationBMC.js IPAddress Username Password FilePath');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var filename = casper.cli.args[3];

    filename = fs.absolute(filename);
    if (!fs.isFile(filename)) {
    	console.log('Invalid File Path!!');
    	casper.exit(1);
    }
    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function CheckFunctionPageLoadFinish() {
	return casper.exists('#btnUpload_restore');
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 5000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
    	casper.waitForSelector('#spanLVL1B3', FunctionPageLinkClick, FunctionInvalid, 5000);
    });
	
	casper.withFrame('headerFrame', function () {
		casper.waitForSelector('#btn0 a', FunctionPageLinkClick1, FunctionInvalid, 5000);
	});	 		
	
	casper.withFrame('dataPage', function () {
		casper.evaluate(function() {
			document.location.href = top.G_objCSRFHandler.getACSRFProtectedUri("upload_cert.html");
		});
		casper.waitForSelector('#file', StartFunction, FunctionInvalid, 5000);
    });
	
    casper.withFrame('headerFrame', function () {
    	casper.waitForSelector('#btn1 a', FunctionPageLinkClick2, FunctionInvalid, 20000);
    });	
}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1B3');
}

function FunctionPageLinkClick1() {
	casper.click('#btn0 a');
}

function FunctionPageLinkClick2() {
	casper.click('#btn1 a');	
}

function StartFunction() {
	casper.page.uploadFile('#file', filename);
	
	casper.evaluate(function() {
		top.headerFrame.document.querySelector("#btn1 a").click();
	});
	
	casper.removeAllFilters('page.confirm');
	casper.setFilter('page.confirm', function(message) {
		return true;
	});
	
	casper.waitForAlert(function(response) {
		console.log(response.data);
		if (response.data == "Certificate upload failed. No pending CSR or private key."){
			console.log('Certificate upload failed. No pending CSR or private key.');
			casper.exit(1);
		}
	}, FileDone , 10000);
	
	
}

function LogInTimeOut() {
	console.log('Open ' + url + ' fail!');
	casper.exit(1);
}

function LogInFail() {
	console.log('LogIn ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	console.log('CA upload Function Invalid!');
	casper.exit(1);
}

function FileInvalid() {
	console.log('CA upload Configuration Fail, Invalid File!!');
	casper.exit(1);
}

function FileDone() {
	console.log('CA upload Configuration success!!');
	casper.exit(0);
}

casper.run();
