var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 3) {
    console.log('Usage: casperjs --ignore-ssl-errors=true fanProfile.js IPAddress Username Password ProfileName');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];

    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function CheckFunctionPageLoadFinish() {
	return casper.exists('#btnUpload_restore');
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 5000);
}

function GoToFunctionPage() {
    	casper.withFrame('bmcTree', function () {
    		casper.waitForSelector('#spanLVL1G', FunctionPageLinkClick, FunctionInvalid, 5000);
    	});

	casper.withFrame('dataPage', function () {
		casper.waitForSelector('#FscRefresh', FunctionPageLinkClick3, FunctionInvalid, 5000);
        });

}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1G');
}

function FunctionPageLinkClick3(){
	//casper.click('#FscRefresh');
	FunctionPageLinkClick2();
}

function FunctionPageLinkClick2() {
	try{
		var temp = casper.evaluate(function() {	
			var length = top.dataPage['G_FSC_INFO'].ProfileData.arrProfile.length;
			var nameArr = new Array(length);
			for(i=0;i<length;i++){
				nameArr[i] = top.dataPage['G_FSC_INFO'].ProfileData.arrProfile[i].strName;
			}
			return nameArr;
		});
		console.log("ID  |  profile name");
		console.log("--- |------------------");
		for(i=0;i<temp.length;i++){
	                console.log(i+"   |   "+temp[i]);
			console.log("--- |------------------");
                }
		console.log("===================");
	}catch(err){
		console.log("error=" + err.message);
	}
	doneReturn();	
}

function LogInTimeOut() {
	console.log('Open ' + url + ' fail!');
	casper.exit(1);
}

function LogInFail() {
	console.log('LogIn ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	console.log('Show Fan profile Function Invalid!');
	casper.exit(1);
}

function doneReturn(){
	console.log('Show up Fan profile success!!');
        casper.exit(0);
}

casper.run();
