#! /bin/sh

# command line parameters
# $1 keylength
# $2 Key file path
# $3 CSR file path
# $4 Country Code (2 letter)
# $5 State/Province
# $6 Locale
# $7 Organization
# $8 Division
# $9 Name
# $9 (after shift 1) email

# return codes:
# 0x00: success
# 0x01: invalid command line parameter

GENCSR=1

#validate the number of command line parameters
if [ $# -eq 11 ] || [ $# -eq 10 ]
then
	day=$1
	keylength=$2
	keyout=$3
	csrout=$4
	city=$5
	state=$6
	locale=$7
	org=$8
	org_unit=$9
	common_name=${10}
	if [ $# -eq 11 ]
	then
		email=${11}
		#create a file that holds the parameters for the openssl command
		CONFFILE=/tmp/gencsr.$$
		cat <<-@eof >$CONFFILE
		[req] 
		prompt = no
		output_password = password
		distinguished_name = dn-param
		attributes = req_attributes
		[dn-param] # DN fields
		C = $city
		ST = $state
		L = $locale
		O = $org
		OU = $org_unit
		CN = $common_name
		emailAddress = $email
		[ v3_ca ]
		subjectKeyIdentifier=hash
		authorityKeyIdentifier=keyid:always,issuer
		basicConstraints = CA:true
		[req_attributes]
		challengePassword = A challenge password
		@eof
	else
		echo no email address specified

		#create a file that holds the parameters for the openssl command
		CONFFILE=/tmp/gencsr.$$
		cat <<-@eof >$CONFFILE
		[req] 
		prompt = no
		output_password = password
		distinguished_name = dn-param
		attributes = req_attributes
		[dn-param] # DN fields
		C = $city
		ST = $state
		L = $locale
		O = $org
		OU = $org_unit
		CN = $common_name
		[ v3_ca ]
		subjectKeyIdentifier=hash
		authorityKeyIdentifier=keyid:always,issuer
		basicConstraints = CA:true
		[req_attributes]
		challengePassword = A challenge password
		@eof
	fi
else
        echo '# command line parameters'
	  echo '# $1 Days'
        echo '# $2 RSA keylength (range 2048 ~ 8192)'
        echo '# $3 Output Key file path'
        echo '# $4 Output CSR file path'
        echo '# $5 Country Code (2 letter ISO 3166)'
        echo '# $6 State/Province'
        echo '# $7 Locale'
        echo '# $8 Organization'
        echo '# $9 Division'
        echo '# $10 Name'
        echo '# $11 (after shift 1) email (optional)'
	  echo '# ex: ./selfsigned_csr.sh 3650 2048 host.key host.cert US FL Sunrise Avocent AESS avocent.com'
	  echo '# put host.key and host.cert below path:'
	  echo '# (ast2500 EMS1.3.5): adps/ast2500_evb_build/apps/securitymgr/securitymgr'
	  echo '# (ast2400): adps/ast4500_evb_build/apps/securitymgr/target_rootfs/etc/default/certs'
	  echo '# (ast2300): adps/ast4500_evb_build/apps/securitymgr/target_rootfs/etc/default/certs'
        echo '# return codes:'	 
        echo '# 0x00: success'
        echo '# 0x01: invalid command line parameter'
	  exit 1
fi
echo keylength: $keylength
echo keyout: $keyout
echo csrout: $csrout
echo city: $city
echo state: $state
echo locale: $locale
echo org: $org
echo org_unit: $org_unit
echo common_name: $common_name
echo email: $email

#openssl req -x509 -nodes -days $day -config $CONFFILE -newkey rsa:$keylength -keyout $keyout -sha256 -out $csrout
openssl req -x509 -nodes -extensions v3_ca -days $day -config $CONFFILE -newkey rsa:$keylength -keyout $keyout -sha256 -out $csrout

#remove the file that holds the parameters
rm -f $CONFFILE

#remove the passphrase from the key
cp $keyout /tmp/cert.key.cryp
openssl rsa -in /tmp/cert.key.cryp -out $keyout -passin pass:password
rm /tmp/cert.key.cryp

# indicate success
GENCSR=0

exit "$GENCSR"

