var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true DumpCrashImg.js <IPAddress> <Username> <Password> <ImgDownloadPath>');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var ImgDownloadPath = casper.cli.args[3];
	
    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 1000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInTimeOut, 5000);
}

function GoToFunctionPage() {
    casper.withFrame('dataPage', function () {
        casper.waitForSelector('#contentArea', 
        function () {
            casper.evaluate(function() {
                document.location.href = top.G_objCSRFHandler.getACSRFProtectedUri("lastcrash.html");
            });
            casper.waitForResource(CheckFileUrl, DownloadCrashImage, FileInvalid, 5000);
        }, LogInTimeOut, 5000);    	   
    });
}

function GetParameterByName(url, name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));    
}

var fileurl = null;
var ST1 = null;
function CheckFileUrl(resource) {
    var tempurl = resource.url;
    ST1 = GetParameterByName(tempurl, "ST1");
    console.log(tempurl);
    if (ST1) {
        console.log(tempurl.search("bsod/bsod.png"));
        if (tempurl.search("bsod/bsod.png") != -1)
        {
            console.log(tempurl);
            fileurl = tempurl;
            return true;
        }
    }

    return false;
}

function DownloadCrashImage() {    
	console.log("Download Crash Image ...");
	//console.log("Download Backup File: " + fileurl);
    console.log('url =' + fileurl);

    var filename = ImgDownloadPath + '/DumpCrash-' + casper.cli.args[0] + '.png';
    filename = fs.absolute(filename);

    /*
    if (fs.exists(filename)) {
        console.log('Invalid File Path!! Exists File Or Directory !!');
        casper.exit(1);
    }
    */
    casper.download(fileurl, filename);
    console.log("Download Crash Image Complete!!");
}

function LogInTimeOut() {
	this.echo('Open ' + url + ' fail!');
}

function FunctionInvalid() {
	this.echo('Dump Crash Image Function Invalid!');
}

function FileInvalid() {
	this.echo('Last Crash Image Is Unavailable');
}

casper.run();
