var xpath = require('casper').selectXPath;
var casper = require('casper').create({
    webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');
var G_url;
if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true PHYInformation.js <IPAddress> <Username> <Password> <FileDownloadPath>');
    casper.exit(1);
} else {        
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var FileDownloadPath = casper.cli.args[3];

    console.log('Connect to ' + url);
    G_url = url;
    casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
    casper.start();

    casper.open(url, {
        method: 'post'
    });
    
    casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 1000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user':        username,
        '#password':    password,
    });

    casper.click('#btnOK');

    casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 1000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
        casper.waitForSelector('#spanLVL5', FunctionPageLinkClick, FunctionInvalid, 5000);
    });

    casper.withFrame('dataPage', function () {
        casper.waitForSelector('#phyInfo', StartFunction, TimeOut, 10000);
    });
}

function FunctionPageLinkClick() {
    casper.click('#spanLVL5');
}

function GetParameterByName(url, name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));    
}

var fileurl = null;
var ST1 = null;
function CheckFileUrl(resource) {
    if (resource.url.match("/json/lsioutJSON.json") !== null) {
        fileurl = resource.url;
        ST1 = GetParameterByName(fileurl, "ST1");
        console.log(ST1);
        return true;
    }

    return false;
}

function DownloadFileFromUrl() {
    console.log("Download File ...");

    var filename = FileDownloadPath + '/lsioutJSON-' + casper.cli.args[0] + '.json';
    filename = fs.absolute(filename);

    var t = new Date();
    t = t.getTime();
    fileurl = G_url + '/json/lsioutJSON.json?_=' + t;
    if (ST1) {
        fileurl += "&ST1=" + ST1;
    }

    fileurl = encodeURI(fileurl);
    console.log(fileurl);

    casper.download(fileurl, filename);
    console.log("Download PHY information JSON file Complete!!");

}

function StartFunction() {
    casper.evaluate(function() {
        Export();
    });
    casper.waitForResource(CheckFileUrl, DownloadFileFromUrl, FileInvalid, 10000);
}

function LogInTimeOut() {
    console.log('Open ' + url + ' fail!');
    casper.exit(1);
}

function LogInFail() {
    console.log('LogIn ' + url + ' fail!');
    casper.exit(1);
}

function FunctionInvalid() {
    console.log('Export PHYInformation Function Invalid!');
    casper.exit(1);
}

function FileInvalid() {
    console.log('Export PHYInformation Fail, Invalid File!!');
    casper.exit(1);
}

function TimeOut() {
    console.log('Export PHYInformation TimeOut!!');
    casper.exit(1);
}

casper.run();
