var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true fanProfile.js IPAddress Username Password ProfileName');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var profileName = casper.cli.args[3];
    
    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function CheckFunctionPageLoadFinish() {
	return casper.exists('#btnUpload_restore');
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 5000);
}

function GoToFunctionPage() {
    	casper.withFrame('bmcTree', function () {
    		casper.waitForSelector('#spanLVL1G', FunctionPageLinkClick, FunctionInvalid, 5000);
    	});

	casper.withFrame('dataPage', function () {
		casper.waitForSelector('#FscRefresh', FunctionPageLinkClick3, FunctionInvalid, 5000);
        });

}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1G');
}

function FunctionPageLinkClick3(){
	FunctionPageLinkClick2();
}

function FunctionPageLinkClick2() {
	try{
		casper.evaluate(function(profileName) {
			var data = {name: profileName};

    			var finish = function () {
				alert("Run Fan profile "+ profileName + " success!!");		
			}


                        var error2 = function () {
                                alert("Run Fan profile "+ profileName + " fail!!");                               
                        }

			GBTLoadXmlDocument(null, 'jsondata/Fsc/Running/Set', data, 'json', finish, error2);	
		},  profileName);

		casper.waitForAlert(function(response) {
			console.log(response.data);
			if (response.data == "Run Fan profile "+ profileName + " fail!!"){
				casper.exit(1);
			}
		}, doneReturn , 10000);
		
	}catch(err){
		console.log("error=" + err.message);
	}
}

function LogInTimeOut() {
	console.log('Open ' + url + ' fail!');
	casper.exit(1);
}

function LogInFail() {
	console.log('LogIn ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	console.log('Show Fan profile Function Invalid!');
	casper.exit(1);
}

function doneReturn(){
	console.log('Run Fan profile '+ profileName + ' success!!');
        casper.exit(0);
}

casper.run();
