var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
	verbose: true,
	logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
	console.log('Usage: casperjs --ignore-ssl-errors=true BackupConfigurationBMC.js IPAddress Username Password StorePath');
	casper.exit(1);
} else {		
	var url = 'https://' + casper.cli.args[0];
	var username = casper.cli.args[1];
	var password = casper.cli.args[2];
	var StorePath = casper.cli.args[3];

	console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
	casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function LogIn() {
	casper.fillSelectors('#auth', {
        	'#user': 	username,
		'#password': 	password,
	});

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInTimeOut, 5000);
}

function GoToFunctionPage() {	
	casper.withFrame('bmcTree', function () {
		casper.waitForSelector('#spanLVL1F', FunctionPageLinkClick, FunctionInvalid, 5000);
	});

	casper.withFrame('dataPage', function () {
		casper.waitForSelector('#btn_backup', StartFunction, FunctionInvalid, 5000);
	});
}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1F');
}

var fileurl;
function CheckBackupFileUrl(resource) {
	if (resource.url.match("/UserCfg/UserConfig.bin") !== null) {	
		fileurl = resource.url;
		return true;
	}
	return false;
}

function DownloadBackupFileFromUrl() {

	console.log("Download Backup File ...");

	var filename = StorePath + '/Backup-' + casper.cli.args[0] + '.bin';
	filename = fs.absolute(filename);

	casper.download(fileurl, filename);
	console.log("Download Backup File Complete!!");

}

function StartFunction() {	
	casper.click('#btn_backup');

	casper.waitForResource(CheckBackupFileUrl, DownloadBackupFileFromUrl, FileInvalid, 10000);
}

function LogInTimeOut() {
	this.echo('Open ' + url + ' fail!');
}

function FunctionInvalid() {
	this.echo('Backup Function Invalid! Maybe platform is not supported.');
}

function FileInvalid() {
	this.echo('Download Backup File Fail');
}

casper.run();
