var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

if (casper.cli.args.length != 3) {
    casper.echo('Usage: casperjs --ignore-ssl-errors=true rebootBMC.js IPAddress username password');
    casper.exit();
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    casper.echo('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start()

	casper.open(url, {
	    method: 'post'
	});

	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, FunctionInvalid, 5000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
    	casper.waitForSelector('#spanLVL1F', FunctionPageLinkClick, FunctionInvalid, 5000);
    });

    casper.withFrame('dataPage', function () {
    	casper.waitForSelector('#btnReboot', StartFunction, FunctionInvalid, 5000);
    });
}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1F');
}

function StartFunction() {	
	casper.click('#btnReboot');

    casper.echo(url + ' is rebooting...');
    casper.exit();
}

function LogInTimeOut() {
	casper.echo('Login Timeout! Reboot ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	casper.echo('Connection Timeout! Reboot ' + url + ' fail!');
	casper.exit(1);
}

casper.run();
