var xpath = require('casper').selectXPath;
var casper = require('casper').create({
    webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');
var G_url;
if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true getSmartHDD.js IPAddress Username Password StorePath');
    casper.exit(1);
} else {        
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
	var StorePath = casper.cli.args[3];
	
    console.log('Connect to ' + url);
    G_url = url;
    casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
    casper.start();

    casper.open(url, {
        method: 'post'
    });
    
    casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 1000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user':        username,
        '#password':    password,
    });

    casper.click('#btnOK');
    casper.waitForResource(CheckFileUrl, DownloadFileFromUrl, LogInFail, 5000);
}

function FunctionPageLinkClick() {
    casper.click('#spanLVL1H');
}

function GetParameterByName(url, name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));    
}

var fileurl = null;
var ST1 = null;
function CheckFileUrl(resource) {
    ST1 = GetParameterByName(resource.url, "ST1");

    if (ST1) {        
        return true;        
    }

    return false;
}

function DownloadFileFromUrl() {
    console.log("Download File ...");
    //console.log("Download Backup File: " + fileurl);

   
	
	var filename = StorePath + '/getSMARTHDD_RAID-' + casper.cli.args[0] + '.json';
    filename = fs.absolute(filename);

    var t = new Date();
    t = t.getTime();
    fileurl = G_url + '/json/gsm.json?_=' + t;
    if (ST1) {
        fileurl += "&ST1=" + ST1;
    }

    fileurl = encodeURI(fileurl);
    console.log(fileurl);

    casper.download(fileurl, filename);
    console.log("Download File Complete!!");

}

function LogInTimeOut() {
    console.log('Open ' + url + ' fail!');
    casper.exit(1);
}

function LogInFail() {
    console.log('LogIn ' + url + ' fail!');
    casper.exit(1);
}

function FunctionInvalid() {
    console.log('Export GSM Data Function Invalid!');
    casper.exit(1);
}

function FileInvalid() {
    console.log('Export GSM Data Fail, Invalid File!!');
    casper.exit(1);
}

function TimeOut() {
    console.log('Export GSM Data TimeOut!!');
    casper.exit(1);
}

casper.run();