var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true BIOSSetupImport.js IPAddress Username Password FilePath');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var filename = casper.cli.args[3];

    filename = fs.absolute(filename);
    if (!fs.isFile(filename)) {
    	console.log('Invalid File Path!!');
    	casper.exit(1);
    }

    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 1000);
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 5000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
    	casper.waitForSelector('#spanLVL1H', nop, FunctionInvalid, 5000);
    });

    casper.withFrame('bmcTree', function () {
        casper.click('#spanLVL1H');
    });

    casper.withFrame('dataPage', function () {
        console.log('Dump BIOS Image...');
    	casper.waitForSelector('#Import', nop, TimeOut, 120000);
    });

    casper.wait(20000, function(){
        casper.withFrame('dataPage', function () {
            casper.click('#Import');
        });

        casper.withFrame('dataPage', function () {
            casper.waitForSelector('#upload-v2-path-ImportDiv', StartFunction, TimeOut, 5000);
        });
    });
}

function nop() {
}

function StartFunction() {
	casper.page.uploadFile('#upload-v2-path-ImportDiv', filename);

    casper.wait(5000, function(){
        console.log('Start Import BIOS Setup Menu Data And Write Modifyed BIOS Back');
        casper.click('#upload-v2-upload-ImportDiv');
        casper.waitForAlert(function(response) {
            console.log(response.data);
            console.log('Upload Complete!!');
            casper.exit(1);
        }, TimeOut, 300000);
    });
}

function LogInTimeOut() {
	console.log('Open ' + url + ' fail!');
	casper.exit(1);
}

function LogInFail() {
	console.log('LogIn ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	console.log('Import BIOS Setup Menu Data Function Invalid!');
	casper.exit(1);
}

function FileInvalid() {
	console.log('Import BIOS Setup Menu Data Fail, Invalid File!!');
	casper.exit(1);
}

function TimeOut() {
    console.log('Import BIOS Setup Menu Data TimeOut!!');
    casper.exit(1);
}

casper.run();
