var xpath = require('casper').selectXPath;
var casper = require('casper').create({
	webSecurityEnabled: false,
    verbose: true,
    logLevel: 'error'
});

var fs = require('fs');

if (casper.cli.args.length != 4) {
    console.log('Usage: casperjs --ignore-ssl-errors=true RestoreConfigurationBMC.js IPAddress Username Password FilePath');
    casper.exit(1);
} else {		
    var url = 'https://' + casper.cli.args[0];
    var username = casper.cli.args[1];
    var password = casper.cli.args[2];
    var filename = casper.cli.args[3];

    filename = fs.absolute(filename);
    if (!fs.isFile(filename)) {
    	console.log('Invalid File Path!!');
    	casper.exit(1);
    }

    console.log('Connect to ' + url);

	casper.userAgent('Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:20.0) Gecko/20100101 Firefox/20.0');
	casper.start();

	casper.open(url, {
	    method: 'post'
	});
	
	casper.then(casper_main);
}

function casper_main(status) {
    casper.waitForSelector('#auth', LogIn, LogInTimeOut, 5000);
}

function CheckFunctionPageLoadFinish() {
	return casper.exists('#btnUpload_restore');
}

function LogIn() {
    casper.fillSelectors('#auth', {
        '#user': 		username,
		'#password': 	password,
    });

	casper.click('#btnOK');

	casper.waitForSelector('frame[name="bmcTree"]', GoToFunctionPage, LogInFail, 5000);
}

function GoToFunctionPage() {
    casper.withFrame('bmcTree', function () {
    	casper.waitForSelector('#spanLVL1F', FunctionPageLinkClick, FunctionInvalid, 5000);
    });

    casper.withFrame('dataPage', function () {
    	casper.waitForSelector('#btnUpload_restore', StartFunction, FunctionInvalid, 5000);
    });
}

function FunctionPageLinkClick() {
	casper.click('#spanLVL1F');
}

function WaitReBoot() {
	console.log('Restore Configuration Finish , Reboot ...');
}

function StartFunction() {
	casper.page.uploadFile('#fileUpload_restore', filename);

    casper.wait(5000, function(){
    	console.log('Start Restore Configuration ...');
        casper.click('#btnUpload_restore');

        casper.waitFor(function check() {
            return this.evaluate(function() {
                return (RestoreGetResault() != 0);
            });
        }, FileInvalid, WaitReBoot, 5000);
    });
}

function LogInTimeOut() {
	console.log('Open ' + url + ' fail!');
	casper.exit(1);
}

function LogInFail() {
	console.log('LogIn ' + url + ' fail!');
	casper.exit(1);
}

function FunctionInvalid() {
	console.log('Restore Function Invalid!');
	casper.exit(1);
}

function FileInvalid() {
	console.log('Restore Configuration Fail, Invalid File!!');
	casper.exit(1);
}

casper.run();
