#!/bin/bash

# usage hints 
function Usage() {
	echo "Usage:"
        echo "  ./bmcWeb.sh reboot   <BMC IP Address> <Username> <Password>                     ;; Reboot BMC"
        echo "  ./bmcWeb.sh dump     <BMC IP Address> <Username> <Password> <Image Store Path>  ;; Capture the image of system crashed"
       	echo "  ./bmcWeb.sh backup   <BMC IP Address> <Username> <Password> <Backup Store Path> ;; Backup the bmc's configure"
        echo "  ./bmcWeb.sh restore  <BMC IP Address> <Username> <Password> <Configure File>    ;; Restore the bmc's configure"
	echo "  ./bmcWeb.sh phyinfo  <BMC IP Address> <Username> <Password> <File Store Path>   ;; Download the bmc's 2U JBOD PHY info"
	echo "  ./bmcWeb.sh bsexport <BMC IP Address> <Username> <Password> <Export Path>       ;; Export BIOS setup as JSON file from BMC"
	echo "  ./bmcWeb.sh bsimport <BMC IP Address> <Username> <Password> <Import File>       ;; Import JSON file of BIOS setup to BMC"
}

# get OS architecture
OSarch=`uname -m`

# export phantomjs sybolic link according to system architecture
if [ "$OSarch" == "x86_64" ]; then
	export PHANTOMJS_EXECUTABLE=./bin/phantomjsX64
else
	export PHANTOMJS_EXECUTABLE=./bin/phantomjsX86
fi

# switch cases by input and execute corresponding JS operation
case $1 in
	# Download upload last crash image from BMC Web
	dump)
		if [ "$#" != "5" ]; then
                        Usage
                        exit 0
                fi
		./bin/casperjs --ignore-ssl-errors=true ./bin/DumpCrashImg.js $2 $3 $4 $5
		;;
	# Reboot BMC
	reboot)
		if [ "$#" != "4" ]; then
                        Usage
                        exit 0
                fi
		./bin/casperjs --ignore-ssl-errors=true ./bin/rebootBMC.js $2 $3 $4
		;;
	# Download BMC configuration binary file
	backup)
        	if [ "$#" != "5" ]; then
            		Usage
            		exit 0
        	fi
        	./bin/casperjs --ignore-ssl-errors=true ./bin/BackupConfigurationBMC.js $2 $3 $4 $5
        	;;
	# Restore the BMC configuration file to remote BMC
    	restore)
        	if [ "$#" != "5" ]; then
            		Usage
            		exit 0
        	fi
        	./bin/casperjs --ignore-ssl-errors=true ./bin/RestoreConfigurationBMC.js $2 $3 $4 $5
        	;;
	# Download 2U JBOD PHY information as JSON file from BMC
	phyinfo)
                if [ "$#" != "5" ]; then
                        Usage
                        exit 0
                fi
                ./bin/casperjs --ignore-ssl-errors=true ./bin/PHYInformation.js $2 $3 $4 $5
                ;;
	# Export BIOS setup menu as JSON file from BMC
	bsexport)
                if [ "$#" != "5" ]; then
                        Usage
                        exit 0
                fi
                ./bin/casperjs --ignore-ssl-errors=true ./bin/BIOSSetupExport.js $2 $3 $4 $5
                ;;
	# Import JSON file of BIOS setup menu to remote BMC 
	bsimport)
                if [ "$#" != "5" ]; then
                        Usage
                        exit 0
                fi
                ./bin/casperjs --ignore-ssl-errors=true ./bin/BIOSSetupImport.js $2 $3 $4 $5
                ;;
	# Get smart HDD information
	gsm_dump)
        if [ "$#" != "5" ]; then
            Usage
            exit 0
        fi
		echo "ready"
		./bin/casperjs --ignore-ssl-errors=true ./bin/getSmartHDD.js $2 $3 $4 $5
		;;
	# Default case to show usage function to user
	*)
		Usage
		;;
esac
