/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.EngineThreadPoolTypes;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractEngineThreadFactory
implements ThreadFactory {
    protected String poolName;
    protected int threadNumbers;
    protected EngineThreadPoolTypes poolType;
    protected boolean daemon;
    protected int priority;
    protected final AtomicLong count;

    protected <T extends ThreadFactoryBuilder<T>> AbstractEngineThreadFactory(T builder) {
        this.poolName = builder.poolName;
        this.threadNumbers = builder.threadNumbers;
        this.poolType = builder.poolType;
        this.daemon = builder.daemon;
        this.priority = builder.priority;
        this.count = new AtomicLong(1L);
    }

    public abstract ExecutorService createThreadPool();

    public abstract ScheduledExecutorService createScheduledThreadPool();

    public void changePoolName(String poolName) {
        this.poolName = poolName;
    }

    public void changeTreadNumbers(int nThreads) {
        this.threadNumbers = nThreads;
    }

    public void changePoolType(EngineThreadPoolTypes poolType) {
        this.poolType = poolType;
    }

    public void changeThreadDaemon(boolean isDaemon) {
        this.daemon = isDaemon;
    }

    public void changeThreadPriority(int priority) {
        this.priority = priority;
    }

    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.poolName + " (" + this.count.getAndIncrement() + ")");
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }

    public static abstract class ThreadFactoryBuilder<T extends ThreadFactoryBuilder<T>> {
        protected String poolName = null;
        protected int threadNumbers = 1;
        protected EngineThreadPoolTypes poolType = EngineThreadPoolTypes.CACHED;
        protected boolean daemon = false;
        protected int priority = 5;

        protected ThreadFactoryBuilder() {
        }

        protected abstract T getThis();

        public abstract AbstractEngineThreadFactory build();

        public T setPoolName(String poolName) {
            if (poolName == null) {
                throw new NullPointerException("Thread name is null !!");
            }
            this.poolName = poolName;
            return this.getThis();
        }

        public T setThreadNumber(int threadNumbers) {
            this.threadNumbers = threadNumbers;
            return this.getThis();
        }

        public T setPoolType(EngineThreadPoolTypes poolType) {
            this.poolType = poolType;
            return this.getThis();
        }

        public T setDaemon(boolean daemon) {
            this.daemon = daemon;
            return this.getThis();
        }

        public T setPriority(int priority) {
            this.priority = priority;
            return this.getThis();
        }
    }
}

