/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.EngineTask;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;

public abstract class AbstractSingleTask
implements EngineTask<EngineRecords> {
    protected volatile String taskID;
    protected volatile Thread currentThread;
    protected volatile AbstractLoggerWriter loggerWriter;

    protected <T extends TaskBuilder<T>> AbstractSingleTask(TaskBuilder<T> taskBuilder) {
        this.taskID = taskBuilder.taskID;
        this.loggerWriter = new DefaultLoggerWriter(this.getClass());
    }

    public abstract void cancelConsideration();

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    public static abstract class TaskBuilder<T extends TaskBuilder<T>> {
        protected String taskID;
        protected StringBuilder sb = new StringBuilder();

        protected TaskBuilder() {
        }

        protected abstract T getThis();

        public abstract EngineTask<?> build();

        public T setTaskName(String taskID) {
            this.taskID = taskID;
            return this.getThis();
        }

        protected T expandTaskID(String exTaskID) {
            if (this.taskID == null) {
                this.sb.append(exTaskID);
            } else {
                this.sb.append(this.taskID).append("-").append(exTaskID);
            }
            this.taskID = this.sb.toString();
            this.sb.setLength(0);
            return this.getThis();
        }
    }
}

