/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.loggers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.menu.GbtUtility;
import org.slf4j.MDC;

public class DefaultLoggerWriter
extends AbstractLoggerWriter {
    public DefaultLoggerWriter() {
        super(DefaultLoggerWriter.class);
    }

    public DefaultLoggerWriter(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void writeLogs(GbtLogLevel level, String logFileName, String messages) {
        if (logFileName == null || messages == null) {
            return;
        }
        if (this.sBuffer.length() > 0) {
            MDC.put((String)this.MDCKey, (String)this.sBuffer.append("/").append(logFileName).append(GbtUtility.additionalLogTime).toString());
        } else {
            MDC.put((String)this.MDCKey, (String)this.sBuffer.append(logFileName).toString());
        }
        this.logMessages.add(String.format("%-7s ", "[" + level.toString() + "]") + messages);
        switch (level) {
            case TRACE: {
                this.logger.trace(messages);
                break;
            }
            case DEBUG: {
                this.logger.debug(messages);
                break;
            }
            case INFO: {
                this.logger.info(messages);
                break;
            }
            case WARN: {
                this.logger.warn(messages);
                break;
            }
            case ERROR: {
                this.logger.error(messages);
                break;
            }
            default: {
                this.logger.info(messages);
            }
        }
        MDC.remove((String)this.MDCKey);
        MDC.clear();
        this.sBuffer.setLength(0);
    }

    @Override
    public void writeLogs(GbtLogLevel level, String logFileName, String messages, Throwable exceptions) {
        if (logFileName == null || messages == null || exceptions == null) {
            return;
        }
        if (this.sBuffer.length() > 0) {
            MDC.put((String)this.MDCKey, (String)this.sBuffer.append("/").append(logFileName).append(GbtUtility.additionalLogTime).toString());
        } else {
            MDC.put((String)this.MDCKey, (String)this.sBuffer.append(logFileName).toString());
        }
        this.logMessages.add(String.format("%-7s ", "[" + level.toString() + "]") + messages + exceptions.getMessage());
        switch (level) {
            case TRACE: {
                this.logger.trace(messages, exceptions);
                break;
            }
            case DEBUG: {
                this.logger.debug(messages, exceptions);
                break;
            }
            case INFO: {
                this.logger.info(messages, exceptions);
                break;
            }
            case WARN: {
                this.logger.warn(messages, exceptions);
                break;
            }
            case ERROR: {
                this.logger.error(messages, exceptions);
                break;
            }
            default: {
                this.logger.info(messages, exceptions);
            }
        }
        MDC.remove((String)this.MDCKey);
        MDC.clear();
        this.sBuffer.setLength(0);
    }
}

