/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCommandReceiver
implements AutoCloseable {
    private volatile AbstractLoggerWriter loggerWriter;
    protected volatile ExecutorService taskPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCommandReceiver() {
        if (this.loggerWriter == null && this.taskPool == null) {
            AbstractCommandReceiver abstractCommandReceiver = this;
            synchronized (abstractCommandReceiver) {
                if (this.loggerWriter == null && this.taskPool == null) {
                    this.loggerWriter = new DefaultLoggerWriter(this.getClass());
                    this.taskPool = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(this.getReceiverName())).setPoolType(EngineThreadPoolTypes.CACHED)).build().createThreadPool();
                }
            }
        }
    }

    public abstract String getReceiverName();

    public abstract boolean closeReceivers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogs(GbtLogLevel level, String commandName, String commandID, String messages) {
        AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
        synchronized (abstractLoggerWriter) {
            this.loggerWriter.appendPath(commandName).writeLogs(level, commandID, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogs(GbtLogLevel level, String commandName, String commandID, String messages, Throwable exceptions) {
        AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
        synchronized (abstractLoggerWriter) {
            this.loggerWriter.appendPath(commandName).writeLogs(level, commandID, messages, exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.loggerWriter != null && this.taskPool != null) {
            AbstractCommandReceiver abstractCommandReceiver = this;
            synchronized (abstractCommandReceiver) {
                if (this.loggerWriter != null && this.taskPool != null) {
                    this.loggerWriter.close();
                    this.loggerWriter = null;
                    this.taskPool.shutdown();
                    do {
                        Thread.sleep(100L);
                    } while (!this.taskPool.awaitTermination(1L, TimeUnit.SECONDS));
                    this.taskPool = null;
                }
            }
        }
    }
}

