/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandCoder;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.RAW.CommonIPMIOptions;
import Gbt.utility.RAW.IPMIRawCommand;
import Gbt.utility.SDR.record.FullSensorRecord;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCPlatform;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bmcinfo.BmcDeviceIpmiOptions;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.firmwareBackup.CommandSupportStatus;
import Gbt.utility.rmc.RMCRole;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.chassis.ChassisControl;
import com.veraxsystems.vxipmi.coding.commands.chassis.ChassisIdentifyControl;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatus;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.GetFruInventoryAreaInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruData;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruDataResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.SetSensorThreshold;
import com.veraxsystems.vxipmi.coding.commands.sdr.SetSensorThresholdResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.ReserveSel;
import com.veraxsystems.vxipmi.coding.commands.sel.ReserveSelResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.SetSessionPrivilegeLevel;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GbtIPMICommandReceiver
extends AbstractCommandReceiver {
    private static volatile GbtIPMICommandReceiver ipmiReceiver;
    private static final int IPMI_CMD_RETRY_COUNT = 5;

    private GbtIPMICommandReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GbtIPMICommandReceiver getInstance() {
        if (ipmiReceiver != null) return ipmiReceiver;
        Class<GbtIPMICommandReceiver> clazz = GbtIPMICommandReceiver.class;
        synchronized (GbtIPMICommandReceiver.class) {
            if (ipmiReceiver != null) return ipmiReceiver;
            ipmiReceiver = new GbtIPMICommandReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipmiReceiver;
        }
    }

    @Override
    public String getReceiverName() {
        return "Gbt IPMI Receiver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean closeReceivers() {
        if (ipmiReceiver != null) {
            GbtIPMICommandReceiver gbtIPMICommandReceiver = this;
            synchronized (gbtIPMICommandReceiver) {
                if (ipmiReceiver != null) {
                    try {
                        ipmiReceiver.close();
                        ipmiReceiver = null;
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public ConnectionHandle createIPMIConnection(String IP, String username, String password, String commandName, String logFileName) {
        ConnectionHandle handle = null;
        try {
            handle = GbtIPMIConnector.getConnector().createConnection(InetAddress.getByName(IP));
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + IP + "] Create IPMI connection.");
            List<CipherSuite> css = GbtIPMIConnector.getConnector().getAvailableCipherSuites(handle);
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + IP + "] Get available cipher suites.");
            GbtIPMIConnector.getConnector().getChannelAuthenticationCapabilities(handle, css, PrivilegeLevel.Administrator);
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + IP + "] Channel authentication allowed.");
            GbtIPMIConnector.getConnector().openSession(handle, username, password, null);
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + IP + "] Open IPMI session success.");
            return handle;
        }
        catch (FileNotFoundException fe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] The vxipmi properties not found.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] " + fe.getMessage());
            this.closeIPMIConnection(handle, commandName, logFileName);
            return null;
        }
        catch (UnknownHostException ue) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] Unknown host : " + IP);
            this.closeIPMIConnection(handle, commandName, logFileName);
            return null;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] The vxipmi properties parameters read error.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] " + ioe.getMessage());
            this.closeIPMIConnection(handle, commandName, logFileName);
            return null;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + IP + "] " + e.getMessage());
            this.closeIPMIConnection(handle, commandName, logFileName);
            return null;
        }
    }

    public ConnectionHandle createIPMIConnection(String IP, String username, String password) {
        return this.createIPMIConnection(IP, username, password, this.getReceiverName(), IP + "_" + this.getReceiverName());
    }

    public void closeIPMIConnection(ConnectionHandle handle, String commandName, String logFileName) {
        if (handle != null) {
            try {
                GbtIPMIConnector.getConnector().closeSession(handle);
                this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI session closed.");
                GbtIPMIConnector.getConnector().closeConnection(handle);
                this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI connection closed.");
            }
            catch (ConnectionException ce) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI connection states error.");
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + ce.getMessage());
            }
            catch (Exception e) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI session, connection close fail.");
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            }
        }
    }

    public void closeIPMIConnection(ConnectionHandle handle, String ipAddress) {
        this.closeIPMIConnection(handle, this.getReceiverName(), ipAddress + "_" + this.getReceiverName());
    }

    public final GbtIpmiCommandResponseData sendRawRequest(ConnectionHandle handle, byte netFn, byte cmdCode, byte[] requestData, String commandName, String logFileName) {
        GbtIpmiCommandResponseData kid = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Interrupted send IPMI command.");
            return kid;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Set session privilege level fail.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            return kid;
        }
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input NetFN          : " + GbtCommonConverters.bytesToHex(netFn));
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Cmd            : " + GbtCommonConverters.bytesToHex(cmdCode));
        if (requestData != null) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Request data   : " + GbtCommonConverters.bytesToHexWithSpace(requestData));
        }
        try {
            kid = netFn == 6 && cmdCode == 52 ? (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendOneWayMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData)) : (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            if (kid.getAllResponseData() != null) {
                this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Output Response data : " + GbtCommonConverters.bytesToHexWithSpace(kid.getAllResponseData()));
            }
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw request success.");
            return kid;
        }
        catch (IPMIException ipmie) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Completion code     : " + GbtCommonConverters.bytesToHex(GbtCommonConverters.intToByte(ipmie.getCompletionCode().getCode())));
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI error messages : " + ipmie.getMessage());
            return kid;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw command fail.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            return kid;
        }
    }

    public GbtIpmiCommandResponseData sendRawRequest(ConnectionHandle handle, byte netFn, byte cmdCode, byte[] requestData) {
        return this.sendRawRequest(handle, netFn, cmdCode, requestData, this.getReceiverName(), handle.getRemoteAddress().getHostAddress() + "_" + this.getReceiverName());
    }

    public final <T extends AbstractCommandBuilder<T>> AbstractJSONPOJO sendIPMIRawCommand(ConnectionHandle handle, GbtIPMIOptions<T> option, T commandArgs, String commandName, String logFileName) {
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Interrupted send IPMI command.");
            return new NullJSONData().setMessages(ie.getMessage()).setError(true);
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Set session privilege level fail.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            return new NullJSONData().setMessages(e.getMessage()).setError(true);
        }
        byte netFn = 0;
        byte cmd = 0;
        if (option == CommonIPMIOptions.RawCommand && commandArgs instanceof IPMIRawCommand.Builder) {
            IPMIRawCommand.Builder temp = (IPMIRawCommand.Builder)commandArgs;
            netFn = temp.getNetFn();
            cmd = temp.getCmd();
        } else {
            netFn = option.getNetFn();
            cmd = option.getCommandCode();
        }
        byte[] reqData = option.rebuildRequestData(commandArgs);
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input NetFN          : " + GbtCommonConverters.bytesToHex(netFn));
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Cmd            : " + GbtCommonConverters.bytesToHex(cmd));
        if (reqData != null) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Request data   : " + GbtCommonConverters.bytesToHexWithSpace(reqData));
        }
        try {
            GbtIpmiCommandResponseData kid = null;
            kid = option.getNetFn() == 6 && option.getCommandCode() == 52 ? (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendOneWayMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData)) : (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            if (kid.getAllResponseData() != null) {
                this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Output Response data : " + GbtCommonConverters.bytesToHexWithSpace(kid.getAllResponseData()));
            }
            return option.parserResponseData(kid);
        }
        catch (IPMIException ipmie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Completion code     : " + GbtCommonConverters.bytesToHex(GbtCommonConverters.intToByte(ipmie.getCompletionCode().getCode())));
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI error messages : " + ipmie.getMessage());
            return new NullJSONData().setMessages(ipmie.getMessage()).setError(true);
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw command fail.");
            e.printStackTrace();
            if (e.getMessage() != null) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            }
            return new NullJSONData().setMessages(e.getMessage()).setError(true);
        }
    }

    public <T extends AbstractCommandBuilder<T>> AbstractJSONPOJO sendIPMIRawCommandWithIpmie(ConnectionHandle handle, GbtIPMIOptions<T> option, T commandArgs, String commandName, String logFileName) throws IPMIException {
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Interrupted send IPMI command.");
            return new NullJSONData().setMessages(ie.getMessage()).setError(true);
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Set session privilege level fail.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            return new NullJSONData().setMessages(e.getMessage()).setError(true);
        }
        byte netFn = 0;
        byte cmd = 0;
        if (option == CommonIPMIOptions.RawCommand && commandArgs instanceof IPMIRawCommand.Builder) {
            IPMIRawCommand.Builder temp = (IPMIRawCommand.Builder)commandArgs;
            netFn = temp.getNetFn();
            cmd = temp.getCmd();
        } else {
            netFn = option.getNetFn();
            cmd = option.getCommandCode();
        }
        byte[] reqData = option.rebuildRequestData(commandArgs);
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input NetFN          : " + GbtCommonConverters.bytesToHex(netFn));
        this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Cmd            : " + GbtCommonConverters.bytesToHex(cmd));
        if (reqData != null) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Input Request data   : " + GbtCommonConverters.bytesToHexWithSpace(reqData));
        }
        try {
            GbtIpmiCommandResponseData kid = null;
            kid = option.getNetFn() == 6 && option.getCommandCode() == 52 ? (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendOneWayMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData)) : (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            if (kid.getAllResponseData() != null) {
                this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Output Response data : " + GbtCommonConverters.bytesToHexWithSpace(kid.getAllResponseData()));
            }
            return option.parserResponseData(kid);
        }
        catch (IPMIException ipmie) {
            throw ipmie;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw command fail.");
            e.printStackTrace();
            if (e.getMessage() != null) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            }
            return new NullJSONData().setMessages(e.getMessage()).setError(true);
        }
    }

    public List<FruRecord> getFRU(ConnectionHandle handle, int fruId, int fruReadSize, String commandName, String logFileName) {
        GetFruInventoryAreaInfoResponseData info;
        try {
            info = (GetFruInventoryAreaInfoResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GetFruInventoryAreaInfo(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, fruId));
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Get FRU inventory area info success.");
        }
        catch (Exception e1) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Failed to get FRU inventory area info.", e1);
            return null;
        }
        ArrayList<ReadFruDataResponseData> fruData = new ArrayList<ReadFruDataResponseData>();
        for (int i = 0; i < info.getFruInventoryAreaSize(); i += fruReadSize) {
            int cnt = fruReadSize;
            if (i + cnt > info.getFruInventoryAreaSize()) {
                cnt = info.getFruInventoryAreaSize() % fruReadSize;
            }
            try {
                ReadFruDataResponseData data = (ReadFruDataResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new ReadFruData(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, fruId, info.getFruUnit(), i, cnt));
                fruData.add(data);
                continue;
            }
            catch (Exception e2) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Get FRU record fail.", e2);
                return null;
            }
        }
        return FruRecord.decodeFruData(fruData);
    }

    public final <T extends FruRecord> T parserFRURecords(List<FruRecord> fruRecords, Class<T> fruInfoType) {
        if (fruRecords != null) {
            for (FruRecord record : fruRecords) {
                if (record.getClass() != fruInfoType) continue;
                return (T)((FruRecord)fruInfoType.cast(record));
            }
        }
        return null;
    }

    public SetSensorThresholdResponseData setSensorThreshold(ConnectionHandle handle, FullSensorRecord record, String commandName, String logFileName) {
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            return (SetSensorThresholdResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new SetSensorThreshold(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, record));
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set sensor threshold fail. (Sensor Number:" + record.getSensorNumber() + ")");
            return null;
        }
    }

    public ReserveSelResponseData getSELReserveID(ConnectionHandle handle, String commandName, String logFileName) {
        ReserveSelResponseData responseData = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            responseData = (ReserveSelResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new ReserveSel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus));
            return responseData;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get SEL reserve ID fail.", e);
            return responseData;
        }
    }

    public boolean chassisPowerCommand(ConnectionHandle handle, PowerCommand powerCmd, String commandName, String logFileName) {
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new ChassisControl(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, powerCmd));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Send chassis command " + powerCmd.toString() + " success.");
            return true;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Interrupted send IPMI command.", ie);
            return false;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Send chassis command " + powerCmd.toString() + " fail.", e);
            return false;
        }
    }

    public boolean chassisIdentifyCommand(ConnectionHandle handle, byte lightTime, String commandName, String logFileName) {
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new ChassisIdentifyControl(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, lightTime));
            return true;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Interrupted send IPMI command.", ie);
            return false;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Send chassis identify light time : " + lightTime + " fail.", e);
            return false;
        }
    }

    public GetChassisStatusResponseData getChassisPowerStates(ConnectionHandle handle, String commandName, String logFileName) {
        GetChassisStatusResponseData chassisStatusResponseData = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            chassisStatusResponseData = (GetChassisStatusResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GetChassisStatus(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Get chassis states success.");
            return chassisStatusResponseData;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Interrupted send IPMI command.", ie);
            return chassisStatusResponseData;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + logFileName.split("_")[0] + "] Get chassis states fail.", e);
            return chassisStatusResponseData;
        }
    }

    public boolean unlockNodePower(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 56;
        byte cmdCode = 48;
        byte[] requestData = new byte[]{0, 0, 0};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Unlock node power success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Unlock node power fail.", e);
            return false;
        }
    }

    public boolean lockNodePower(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 56;
        byte cmdCode = 48;
        byte[] requestData = new byte[]{0, 0, 4};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Lock node power success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Lock node power fail.", e);
            return false;
        }
    }

    public boolean resetBMCCold(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 6;
        byte cmdCode = 2;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, null));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Send BMC reset cold success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Send BMC reset cold fail.", e);
            return false;
        }
    }

    public boolean sendCancel(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 8;
        byte cmdCode = 21;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, null));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Send BMC cancel success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Send BMC cancel fail.", e);
            return false;
        }
    }

    public boolean setBootOption(ConnectionHandle handle, BootOptions bootOption, boolean uefiMode, String commandName, String logFileName) {
        byte netFn = 0;
        byte cmdCode = 8;
        byte[] requestData = new byte[]{5, uefiMode ? (byte)-96 : -128, bootOption.getOptionsCode(), 0, 0, 0};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, new byte[]{0, 0}));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, new byte[]{0, 1}));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, new byte[]{4, 1, 1}));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set boot option (" + bootOption.toString() + ") success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set boot option (" + bootOption.toString() + ") fail.", e);
            return false;
        }
    }

    public Map<String, String> get3LANMACs(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 56;
        byte cmdCode = 48;
        byte[] requestData = new byte[]{2};
        byte[] macByte = new byte[6];
        GbtIpmiCommandResponseData rawData = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            rawData = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Get LAN MAC raw data success.");
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get LAN MAC raw data fail.", e);
            return null;
        }
        HashMap<String, String> macs = new HashMap<String, String>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < macByte.length; ++j) {
                macByte[j] = rawData.getResponseData(j + (i * 6 + 4));
            }
            if (i == 0) {
                macs.put("BMC", CommonFunction.byteMACtoString(macByte));
                this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "BMC  LAN MAC address : " + (String)macs.get("BMC"));
                continue;
            }
            macs.put("LAN" + i, CommonFunction.byteMACtoString(macByte));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Data LAN" + i + " MAC address : " + (String)macs.get("LAN" + i));
        }
        return macs;
    }

    public String getOR20Role(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmdCode = 17;
        byte[] requestData = new byte[]{10, 60, 0, 69};
        GbtIpmiCommandResponseData kid = null;
        String result = "Unknown";
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Get OR20 role success.");
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get OR20 role fail.", e);
            return result;
        }
        if (kid.getResponseData(0) == 10 && kid.getResponseData(1) == 60 && kid.getResponseData(2) == 0) {
            switch (kid.getResponseData(3)) {
                case 1: {
                    result = "RMC_M";
                    break;
                }
                case 2: {
                    result = "RMC_S";
                    break;
                }
                case 3: {
                    result = "CB_5U";
                    break;
                }
                case 4: {
                    result = "CB_8U";
                    break;
                }
                case -128: {
                    result = "CMC";
                    break;
                }
                default: {
                    result = "Unknown";
                }
            }
        }
        return result;
    }

    public boolean setIPv6Grantley(ConnectionHandle handle, String commandName, String logFileName, byte commandCode) {
        byte netFn = 46;
        byte cmdCode = 32;
        byte[] requestData = new byte[]{10, 60, 0, 4, 0, commandCode};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            if (commandCode == 2) {
                Thread.sleep(500L);
                requestData = new byte[]{10, 60, 0, 4, 3};
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set IPv6 Grantley success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set IPv6 Grantley fail.", e);
            return false;
        }
    }

    public boolean setIPv6RomleyOR(ConnectionHandle handle, String commandName, String logFileName, byte commandCode) {
        byte netFn = 48;
        byte cmdCode = -121;
        byte[] requestData = new byte[]{0, commandCode};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set IPv6 Open rack Romley success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set IPv6 Open rack Romley fail.", e);
            return false;
        }
    }

    public boolean setIPv6RomleyNormal(ConnectionHandle handle, String commandName, String logFileName, byte commandCode) {
        byte netFn = 48;
        byte cmdCode = -84;
        byte[] requestData = new byte[]{10, 1, 0, commandCode};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            if (commandCode == 2) {
                Thread.sleep(500L);
                requestData = new byte[]{10, 1, 3};
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set IPv6 normal Romley success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set IPv6 normal Romley fail.", e);
            return false;
        }
    }

    public boolean logoChangeCommand(ConnectionHandle handle, String commandName, String logFileName, String tftpIP) {
        byte netFn = 46;
        byte cmdCode = 32;
        byte[] ipv4 = GbtCommonConverters.ipv4ToBytes(tftpIP);
        byte[] requestData = new byte[]{10, 60, 0, 16, 0, ipv4[0], ipv4[1], ipv4[2], ipv4[3]};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "LOGO change command fail.", e);
            return false;
        }
        cmdCode = 33;
        requestData = new byte[]{10, 60, 0, 16};
        int count = 0;
        boolean success = false;
        while (count < 2) {
            try {
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
                success = true;
                this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "LOGO change command success.");
                ++count;
            }
            catch (Exception e) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "LOGO change command fail.");
                success = false;
                ++count;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSMBIOSAndHDDInfo(ConnectionHandle handle, String remoteFileName, File outputFile, int type, String commandName, String logFileName) {
        int maxWaitingCount = 1000;
        FileOutputStream output = null;
        try {
            byte[] result;
            output = new FileOutputStream(outputFile);
            byte[] bytesFilename = remoteFileName.getBytes();
            byte[] FileSizeBytes = this.File_Act(handle, 0, bytesFilename);
            byte[] FileSizetoConvert = new byte[]{FileSizeBytes[3], FileSizeBytes[4], FileSizeBytes[5], FileSizeBytes[6]};
            int FileSize = GbtCommonConverters.ByteArraytoInt(FileSizetoConvert);
            int PreRecvSize = 0;
            int waitingCount = 0;
            for (int RecvSize = 0; FileSize > RecvSize; RecvSize += result[3]) {
                if (PreRecvSize == RecvSize) {
                    this.writeLogs(GbtLogLevel.DEBUG, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Download progress is stop, count:" + waitingCount);
                    ++waitingCount;
                } else {
                    waitingCount = 0;
                }
                if (waitingCount >= maxWaitingCount) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Watting SMBIOS file timeout!");
                    boolean bl = false;
                    return bl;
                }
                byte[] offsetBytes = new byte[2];
                byte[] sizebytes = GbtCommonConverters.intToByteArray(RecvSize);
                for (int i = 0; i < offsetBytes.length; ++i) {
                    offsetBytes[i] = sizebytes[sizebytes.length - 1 - i];
                }
                result = this.File_Act(handle, 1, offsetBytes);
                byte[] temp = new byte[result.length - 4];
                System.arraycopy(result, 4, temp, 0, temp.length);
                switch (type) {
                    case 0: {
                        try {
                            output.write(new String(temp, StandardCharsets.UTF_8).getBytes());
                        }
                        catch (UnsupportedEncodingException uee) {
                            output.write(temp);
                        }
                        break;
                    }
                    default: {
                        output.write(temp);
                    }
                }
                output.flush();
                PreRecvSize = RecvSize;
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Cannot find output file.", fe);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Write SMBIOS or HWInfo file I/O error.", ioe);
            boolean bl = false;
            return bl;
        }
        catch (Exception ee) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Write SMBIOS or HWInfo file fail caused by other reason.", ee);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLogs(GbtLogLevel.DEBUG, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Close output stream.");
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] File output stream close fail.", e);
                }
            }
        }
    }

    private byte[] File_Act(ConnectionHandle handle, int act, byte[] appendData) {
        int netFn = 46;
        byte cmd = 0;
        int CMD_DL_FILE_INIT_CMD = 32;
        int CMD_DL_FILE_GET_DONE_CMD = 33;
        byte[] CMD_DL_FILE_INIT = new byte[]{10, 60, 0, 48};
        byte[] CMD_DL_FILE_GET = new byte[]{10, 60, 0, 49};
        byte[] CMD_DL_FILE_DONE = new byte[]{10, 60, 0, 50};
        int BASE_RQ_DATA_LENGTH = 4;
        byte[] requestData = new byte[4 + appendData.length];
        switch (act) {
            case 0: {
                cmd = 32;
                System.arraycopy(CMD_DL_FILE_INIT, 0, requestData, 0, CMD_DL_FILE_INIT.length);
                break;
            }
            case 1: {
                cmd = 33;
                System.arraycopy(CMD_DL_FILE_GET, 0, requestData, 0, CMD_DL_FILE_GET.length);
                break;
            }
            case 2: {
                cmd = 33;
                System.arraycopy(CMD_DL_FILE_DONE, 0, requestData, 0, CMD_DL_FILE_DONE.length);
            }
        }
        System.arraycopy(appendData, 0, requestData, 4, appendData.length);
        int retry = 0;
        byte[] result = new byte[]{0, 0, 0, 0};
        while (true) {
            try {
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIpmiCommandResponseData rawData = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), 46, cmd, requestData));
                result = rawData.getAllResponseData();
            }
            catch (Exception e) {
                if (++retry < 5) continue;
            }
            break;
        }
        return result;
    }

    public byte[] setNTP(ConnectionHandle handle, byte cmd, byte[] requestData, String commandName, String logFileName) {
        byte[] resultArray = null;
        byte netFn = 46;
        GbtIpmiCommandResponseData rawData = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            rawData = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, requestData));
            resultArray = rawData.getAllResponseData();
            if (resultArray != null) {
                this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, GbtCommonConverters.bytesToHexWithSpace(resultArray));
                this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set NTP success.");
            } else {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set NTP fail.");
            }
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set NTP fail.", e);
        }
        return resultArray;
    }

    public boolean setTrapIP(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte netFn = 12;
        byte cmd = 1;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Set trap ipv4 fail.", e);
            return false;
        }
    }

    public boolean setTrapIPV6(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = -52;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Set trap ipv6 fail.", e);
            return false;
        }
    }

    public byte[] getTrapIPV6(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte[] result = null;
        byte netFn = 46;
        byte cmd = -52;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            result = kid.getAllResponseData();
            return result;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Get trap ipv6 fail.", e);
            return result;
        }
    }

    public byte[] getPEFConfig(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte[] result = null;
        byte netFn = 4;
        byte cmd = 19;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            result = kid.getAllResponseData();
            return result;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get PEF fail.", e);
            return result;
        }
    }

    public boolean setPEFConfig(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte netFn = 4;
        byte cmd = 18;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set PEF fail.", e);
            return false;
        }
    }

    public byte[] getGlobalAlertEnable(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte[] result = null;
        byte netFn = 6;
        byte cmd = 65;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            result = kid.getAllResponseData();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get Global Alert Enable fail.", e);
        }
        return result;
    }

    public Boolean getGlobalAlertEnable(ConnectionHandle handle, String commandName, String logFileName) {
        byte[] result = null;
        byte netFn = 6;
        byte cmd = 65;
        byte[] reqData = new byte[]{1, -128};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            result = kid.getAllResponseData();
            if ((result[0] & 0x20) == 32) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get Global Alert Enable fail.", e);
            return null;
        }
    }

    public boolean setGlobalAlertEnable(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte netFn = 6;
        byte cmd = 64;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set Global Alert Enable fail.", e);
            return false;
        }
    }

    public boolean setGlobalAlertEnable(ConnectionHandle handle, boolean enable, String commandName, String logFileName) {
        byte netFn = 6;
        byte cmd = 64;
        byte[] reqData = new byte[]{1, -126, -124};
        reqData[1] = enable ? -126 : -94;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set Global Alert Enable fail.", e);
            return false;
        }
    }

    public byte[] getGPUFanPolicy(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 17;
        byte[] requestData = new byte[]{10, 60, 0, -121};
        byte[] result = new byte[1];
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, requestData));
            result[0] = kid.getResponseData(3);
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get GPU Fan Policy fail.", e);
        }
        return result;
    }

    public boolean setGPUFanPolicy(ConnectionHandle handle, int policyID, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 16;
        byte[] requestData = new byte[]{10, 60, 0, -121, (byte)policyID};
        boolean status = false;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Set GPU Fan Policy sucess.");
            status = true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set GPU Fan Policy fail.", e);
            status = false;
        }
        return status;
    }

    public boolean rmcPublishWrite(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        int retry = 0;
        boolean done = false;
        byte netFn = 46;
        byte cmd = 61;
        do {
            try {
                ++retry;
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
                done = true;
            }
            catch (Exception e) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set GPU Fan Policy fail.", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Interrupt GPU Fan Policy.", e1);
                    return done;
                }
            }
        } while (!done && retry < 5);
        return done;
    }

    public byte[] masterWriteReadCommand(ConnectionHandle handle, byte[] reqData, String commandName, String logFileName) {
        byte netFn = 6;
        byte cmd = 82;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return kid.getAllResponseData();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Set Global Alert Enable fail.", e);
            return null;
        }
    }

    public final BMCVendor getBmcVendor(ConnectionHandle handle, String commandName, String logFileName) {
        BMCVendor vendor = BMCVendor.parse(this.sendRawRequest(handle, (byte)46, (byte)17, new byte[]{10, 60, 0, 22}, commandName, logFileName));
        if (vendor == BMCVendor.UNKNOWN) {
            BMCPlatform bmcPlatform;
            this.writeLogs(GbtLogLevel.TRACE, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Not support BMC vendor command, try to get device ID.");
            AbstractJSONPOJO resp = this.sendIPMIRawCommand(handle, BmcDeviceIpmiOptions.GETDEVICEID, null, commandName, logFileName);
            if (resp instanceof BMCInfoJSONData && ((bmcPlatform = resp.castConcreteJSON(BMCInfoJSONData.class).getProductName()).isAST2400() || bmcPlatform.isCMC())) {
                vendor = BMCVendor.VERTIV;
            }
        }
        return vendor;
    }

    public boolean unlockUpdateMode(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmdCode = 62;
        byte[] requestData = new byte[]{10, 60, 0, 1, 0, 1, 12};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Unlock node update status success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Unlock node update status fail.", e);
            return false;
        }
    }

    public byte[] SGPIOCommand(ConnectionHandle handle, byte cpldLocation, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 16;
        byte[] reqData = new byte[]{10, 60, 0, -106, 0, cpldLocation};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return kid.getAllResponseData();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get SGPIO fail.", e);
            return null;
        }
    }

    public boolean sensorScanActionCommand(ConnectionHandle handle, byte sensorAction, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmdCode = 16;
        byte[] requestData = new byte[]{10, 60, 0, 4, sensorAction};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmdCode, requestData));
            this.writeLogs(GbtLogLevel.INFO, commandName, logFileName, "Sensor Action success.");
            return true;
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Sensor Action fail.", e);
            return false;
        }
    }

    public byte[] getCPLDOemCommand(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 17;
        byte[] reqData = new byte[]{10, 60, 0, 17};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return kid.getAllResponseData();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get CPLD version new function fail.");
            return null;
        }
    }

    public byte[] getCPLDUserCode(ConnectionHandle handle, byte cpldLocation, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 17;
        byte[] reqData = new byte[]{10, 60, 0, 13, cpldLocation};
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            return kid.getAllResponseData();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get CPLD version old function fail.");
            return null;
        }
    }

    public RMCRole getRMCRoleCommand(ConnectionHandle handle, String commandName, String logFileName) {
        block8: {
            byte netFn = 46;
            byte cmd = 17;
            byte[] reqData = new byte[]{10, 60, 0, 69};
            try {
                GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
                GbtIpmiCommandResponseData responseData = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
                if (responseData.isHasResponseData()) {
                    if (responseData.getResponseData(responseData.getAllResponseData().length - 1) == RMCRole.RMC_M.getTypeCode()) {
                        return RMCRole.RMC_M;
                    }
                    if (responseData.getResponseData(responseData.getAllResponseData().length - 1) == RMCRole.RMC_S.getTypeCode()) {
                        return RMCRole.RMC_S;
                    }
                    if (responseData.getResponseData(responseData.getAllResponseData().length - 1) == RMCRole.CB_5U.getTypeCode()) {
                        return RMCRole.CB_5U;
                    }
                    if (responseData.getResponseData(responseData.getAllResponseData().length - 1) == RMCRole.CB_8U.getTypeCode()) {
                        return RMCRole.CB_8U;
                    }
                    if ((byte)(responseData.getResponseData(responseData.getAllResponseData().length - 1) & 0xF0) == RMCRole.CMC.getTypeCode()) {
                        return RMCRole.CMC;
                    }
                    break block8;
                }
                return RMCRole.UNKNOWN;
            }
            catch (Exception e) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get RMC Role fail.", e);
                return null;
            }
        }
        return RMCRole.UNKNOWN;
    }

    public byte[] OR20IPMBIPGetCommand(RMCRole rmcRole, String RMCIP, byte IPMBBusNo, ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 6;
        byte cmd = 52;
        byte SA = 0;
        byte DA = 0;
        byte checkSum = 0;
        int temp = -2;
        if (rmcRole == RMCRole.RMC_M) {
            SA = 40;
            DA = 42;
            checkSum = (byte)(256 - (temp + SA) & 0xFF);
        } else if (rmcRole == RMCRole.RMC_S) {
            SA = 42;
            DA = 40;
            checkSum = (byte)(256 - (temp + SA) & 0xFF);
        }
        IPMBBusNo = (byte)(IPMBBusNo | 0x40);
        byte[] Data = new byte[]{IPMBBusNo, SA, -72, checkSum, DA, 0};
        byte[] reqData = new byte[]{60, 10, 60, 0, 4, 3};
        byte[] RequestData = GIGABYTEChecksum.getChecksumIPMIReq(Data, reqData);
        byte[] result = new byte[1];
        try {
            GbtIPMIConnector.getConnector().sendOneWayMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, RequestData));
            if (kid.isHasResponseData()) {
                result = kid.getAllResponseData();
            }
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get IPMB IP fail.", e);
            return null;
        }
        return result;
    }

    public final byte[] GSMAgentIPGetCommand(ConnectionHandle handle, String commandName, String logFileName) {
        byte netFn = 46;
        byte cmd = 33;
        byte[] reqData = new byte[]{10, 60, 0, 81};
        byte[] respData = null;
        try {
            GbtIPMIConnector.getConnector().sendMessage(handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
            GbtIpmiCommandResponseData responseData = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(handle, new GbtIpmiCommandCoder(handle.getCipherSuite(), netFn, cmd, reqData));
            if (responseData.isHasResponseData()) {
                respData = responseData.getAllResponseData();
            }
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "Get GSM agent IP fail.", e);
        }
        return respData;
    }

    public <T extends AbstractCommandBuilder<T>> List<AbstractJSONPOJO> sendGbtOEMCommand(ConnectionHandle handle, GbtIPMIOptions<T> option, T commandArgs, String commandName, String logFileName) {
        ArrayList<AbstractJSONPOJO> commandResults = new ArrayList<AbstractJSONPOJO>();
        try {
            AbstractJSONPOJO resp = this.sendIPMIRawCommandWithIpmie(handle, option, commandArgs, commandName, logFileName);
            if (resp instanceof CommandSupportStatus) {
                commandResults.add(resp);
            } else if (resp instanceof NullJSONData) {
                boolean isError = resp.castConcreteJSON(NullJSONData.class).isError();
                commandResults.add(resp);
                commandResults.add(new CommandSupportStatus().setSupport(true).setSuccess(!isError));
            } else {
                commandResults.add(resp);
                commandResults.add(new CommandSupportStatus().setSupport(true).setSuccess(true));
            }
        }
        catch (IPMIException e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Completion code     : " + GbtCommonConverters.bytesToHex(GbtCommonConverters.intToByte(e.getCompletionCode().getCode())));
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] IPMI error messages : " + e.getMessage());
            if (e.getCompletionCode().getCode() == CompletionCode.ReservationCanceled.getCode() || e.getCompletionCode().getCode() == CompletionCode.CommandSpecifedCode.getCode()) {
                commandResults.add(new CommandSupportStatus().setSupport(false).setSuccess(false));
            } else {
                commandResults.add(new CommandSupportStatus().setSupport(true).setSuccess(false));
            }
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw command fail.");
            e.printStackTrace();
            if (e.getMessage() != null) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, logFileName, "[" + handle.getRemoteAddress().getHostAddress() + "] " + e.getMessage());
            }
            commandResults.add(new CommandSupportStatus().setSupport(false).setSuccess(false));
        }
        return commandResults;
    }
}

