/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.tftp;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.tftp.TFTPServer;
import Gbt.utility.Common.SocketUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;

public final class GlobalTFTPServer {
    private static final String SERVICE_NAME = "tftp";
    private static volatile GlobalTFTPServer instance;
    private volatile TFTPServer tftpServer;
    private volatile List<String> threadMembers = new ArrayList<String>();
    private volatile Map<String, File> fileUsageMap;
    private AbstractLoggerWriter logger = new DefaultLoggerWriter(this.getClass());

    private GlobalTFTPServer() {
        this.fileUsageMap = new ConcurrentHashMap<String, File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GlobalTFTPServer access() {
        if (instance != null) return instance;
        Class<GlobalTFTPServer> clazz = GlobalTFTPServer.class;
        synchronized (GlobalTFTPServer.class) {
            if (instance != null) return instance;
            instance = new GlobalTFTPServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startTFTPServer(File tftpPath, int port, String commandName, String commandID) {
        if (port == 0) {
            port = 69;
        }
        if (this.tftpServer == null) {
            GlobalTFTPServer globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                this.threadMembers.add(Thread.currentThread().getName());
                if (this.tftpServer == null) {
                    if (!SocketUtil.isPortAvailable(port)) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] The given port : " + port + " is unavailable or already used by other program.");
                        return false;
                    }
                    try {
                        this.tftpServer = new TFTPServer(tftpPath, tftpPath, port, TFTPServer.ServerMode.GET_AND_PUT, System.out, System.err);
                        this.tftpServer.setSocketTimeout(1000);
                        boolean state = this.tftpServer.isRunning();
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Open TFTP server(" + port + ") success.");
                        return state;
                    }
                    catch (IOException ioe) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Given TFTP path not exist.", ioe);
                        return false;
                    }
                    catch (Exception e) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Open TFTP server fail.", e);
                        return false;
                    }
                }
                this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] TFTP server has been activated.");
            }
        }
        GlobalTFTPServer globalTFTPServer = this;
        synchronized (globalTFTPServer) {
            this.threadMembers.add(Thread.currentThread().getName());
            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] TFTP server has been activated.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startTFTPServer(String tftpPath, int port, String commandName, String commandID) {
        if (port == 0) {
            port = 69;
        }
        if (this.tftpServer == null) {
            GlobalTFTPServer globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                this.threadMembers.add(Thread.currentThread().getName());
                if (this.tftpServer == null) {
                    if (!SocketUtil.isPortAvailable(port)) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] The given port : " + port + " is unavailable or already used by other program.");
                        return false;
                    }
                    File tftpRoot = new File(tftpPath);
                    if (!tftpRoot.exists()) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] The given TFTP path is not exist.");
                        return false;
                    }
                    if (!tftpRoot.isDirectory()) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] The given TFTP path is not a directory.");
                        return false;
                    }
                    try {
                        this.tftpServer = new TFTPServer(tftpRoot, tftpRoot, port, TFTPServer.ServerMode.GET_AND_PUT, System.out, System.err);
                        this.tftpServer.setSocketTimeout(1000);
                        boolean state = this.tftpServer.isRunning();
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Open TFTP server(" + port + ") success.");
                        return state;
                    }
                    catch (IOException ioe) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Given TFTP path not exist.", ioe);
                        return false;
                    }
                    catch (Exception e) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Open TFTP server(" + port + ") fail.", e);
                        return false;
                    }
                }
                this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] TFTP server has been activated.");
            }
        }
        GlobalTFTPServer globalTFTPServer = this;
        synchronized (globalTFTPServer) {
            this.threadMembers.add(Thread.currentThread().getName());
            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] TFTP server has been activated.");
        }
        return true;
    }

    public final boolean startTFTPServer(File tftpPath, int port) {
        return this.startTFTPServer(tftpPath, port, SERVICE_NAME, "tftp_records");
    }

    public final boolean startTFTPServer(String tftpPath, int port) {
        return this.startTFTPServer(tftpPath, port, SERVICE_NAME, "tftp_records");
    }

    public final boolean startTFTPServer(File tftpPath, String commandName, String commandID) {
        return this.startTFTPServer(tftpPath, 69, commandName, commandID);
    }

    public final boolean startTFTPServer(String tftpPath, String commandName, String commandID) {
        return this.startTFTPServer(tftpPath, 69, commandName, commandID);
    }

    public final boolean startTFTPServer(File tftpPath) {
        return this.startTFTPServer(tftpPath, 69);
    }

    public final boolean startTFTPServer(String tftpPath) {
        return this.startTFTPServer(tftpPath, 69);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void shutdownTFTPServer(File tftpPath, boolean force, String commandName, String commandID) {
        if (this.tftpServer == null) return;
        GlobalTFTPServer globalTFTPServer = this;
        synchronized (globalTFTPServer) {
            String threadName = Thread.currentThread().getName();
            this.threadMembers.remove(threadName);
            if (force) {
                this.threadMembers.clear();
            }
            if (this.threadMembers.isEmpty()) {
                this.tftpServer.shutdown();
                int count = 0;
                do {
                    try {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Wait for TFTP server shutdown ... (" + ++count + ")");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.WARN, commandID, "[" + commandID.split("_")[0] + "] Interrupt wait the TFTP server shutdown.", ie);
                        break;
                    }
                } while (this.tftpServer.isRunning() && count < 10);
                this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Close TFTP server success.");
                try {
                    if (tftpPath == null || !tftpPath.exists()) return;
                    FileUtils.deleteDirectory((File)tftpPath);
                    this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Remove the TFTP path : " + tftpPath.getAbsolutePath());
                }
                catch (IOException ioe) {
                    this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Can not remove the TFTP path : " + tftpPath.getAbsolutePath(), ioe);
                }
                finally {
                    try {
                        this.tftpServer = null;
                        this.threadMembers = null;
                        this.logger.close();
                        this.logger = null;
                        instance = null;
                    }
                    catch (Exception e) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Resource close fail.");
                    }
                }
            } else {
                this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] TFTP server still used by other threads, so skip close.");
            }
            return;
        }
    }

    public final void shutdownTFTPServer(File tftpPath, boolean force) {
        this.shutdownTFTPServer(tftpPath, force, SERVICE_NAME, "tftp_records");
    }

    public final void shutdownTFTPServer(boolean force, String commandName, String commandID) {
        this.shutdownTFTPServer(null, force, commandName, commandID);
    }

    public final void shutdownTFTPServer(boolean force) {
        this.shutdownTFTPServer(null, force, SERVICE_NAME, "tftp_records");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean copyFileToTFTPServer(File srcFile, File dstFileName, String commandName, String commandID) {
        GlobalTFTPServer globalTFTPServer;
        if (!srcFile.exists()) {
            globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                if (!srcFile.exists()) {
                    this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Given source file or dictionary not exists.");
                    return false;
                }
            }
        }
        if (!dstFileName.exists()) {
            globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                this.fileUsageMap.put(Thread.currentThread().getName(), dstFileName);
                if (!dstFileName.exists()) {
                    if (!dstFileName.getParentFile().exists()) {
                        dstFileName.getParentFile().mkdir();
                    }
                    try {
                        FileInputStream srcInputStream = new FileInputStream(srcFile);
                        FileOutputStream dstInputStream = new FileOutputStream(dstFileName);
                        FileChannel srcChannel = srcInputStream.getChannel();
                        FileChannel dstChannel = dstInputStream.getChannel();
                        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                        srcChannel.close();
                        dstChannel.close();
                        srcInputStream.close();
                        dstInputStream.close();
                        if (srcFile.isDirectory()) {
                            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Copy source dir  : " + srcFile.getAbsolutePath());
                        } else {
                            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Copy source file : " + srcFile.getAbsolutePath());
                        }
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] To destination   : " + dstFileName.getAbsolutePath());
                        return true;
                    }
                    catch (IOException ioe) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Copy file fail.", ioe);
                        return false;
                    }
                }
                this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Destination files or dictionary has already copied, skip override it.");
            }
        }
        globalTFTPServer = this;
        synchronized (globalTFTPServer) {
            this.fileUsageMap.put(Thread.currentThread().getName(), dstFileName);
            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Destination files or dictionary has already copied, skip override it.");
        }
        return true;
    }

    public final boolean copyFileToTFTPServer(File srcFile, File dstFileName) {
        return this.copyFileToTFTPServer(srcFile, dstFileName, SERVICE_NAME, "tftp_records");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFileFromTFTPServer(File usageFile, String commandName, String commandID) {
        GlobalTFTPServer globalTFTPServer;
        if (usageFile == null) {
            globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                if (usageFile == null) {
                    this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] Destination file or dictionary is null.");
                    return;
                }
            }
        }
        if (usageFile.exists()) {
            globalTFTPServer = this;
            synchronized (globalTFTPServer) {
                if (usageFile.exists()) {
                    String threadName = Thread.currentThread().getName();
                    this.fileUsageMap.remove(threadName);
                    for (String key : this.fileUsageMap.keySet()) {
                        try {
                            if (!FileUtils.contentEquals((File)usageFile, (File)this.fileUsageMap.get(key))) continue;
                            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] " + usageFile.getAbsolutePath() + " still used by other threads.");
                            return;
                        }
                        catch (IOException ioe) {
                            this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] File or dictionary read fail.", ioe);
                            return;
                        }
                    }
                    try {
                        if (usageFile.isDirectory()) {
                            FileUtils.deleteDirectory((File)usageFile);
                        } else {
                            FileUtils.deleteQuietly((File)usageFile);
                        }
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Remove " + usageFile.getAbsolutePath() + " from TFTP server path.");
                    }
                    catch (IOException ioe) {
                        this.logger.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandID, "[" + commandID.split("_")[0] + "] File or dictionary read fail.", ioe);
                    }
                } else {
                    this.logger.appendPath(commandName).writeLogs(GbtLogLevel.DEBUG, commandID, "[" + commandID.split("_")[0] + "] Destination files or dictionary has already removed.");
                }
            }
        }
    }
}

