/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import Gbt.core.vmedia.protocol.IUSBHeader;
import Gbt.core.vmedia.protocol.SCSICommandPacket;
import Gbt.core.vmedia.protocol.SCSIStatusPacket;
import java.nio.ByteBuffer;

public class IUSBSCSIPacket {
    private IUSBHeader header;
    private int readLen;
    private int tagNo;
    private byte dataDir;
    private SCSICommandPacket commandPkt;
    private SCSIStatusPacket statusPkt;
    private int dataLen;
    private byte data;
    private int[] values;

    public IUSBSCSIPacket(ByteBuffer request) {
        request.rewind();
        this.setHeader(new IUSBHeader(request));
        this.setReadLen(request.getInt());
        this.setTagNo(request.getInt());
        this.setDataDir(request.get());
        this.setCommandPkt(new SCSICommandPacket(request));
        this.setStatusPkt(new SCSIStatusPacket(request));
        this.setDataLen(request.getInt());
        request.rewind();
    }

    public int getReadLen() {
        return this.readLen;
    }

    public void setReadLen(int readLen) {
        this.readLen = readLen & 0xFF;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public void setTagNo(int tagNo) {
        this.tagNo = tagNo & 0xFF;
    }

    public int getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(int dataDir) {
        this.dataDir = (byte)dataDir;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int dataLen) {
        this.dataLen = dataLen;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int data) {
        this.data = (byte)data;
    }

    public IUSBHeader getHeader() {
        return this.header;
    }

    public void setHeader(IUSBHeader header) {
        this.header = header;
    }

    public SCSICommandPacket getCommandPkt() {
        return this.commandPkt;
    }

    public void setCommandPkt(SCSICommandPacket commandPkt) {
        this.commandPkt = commandPkt;
    }

    public SCSIStatusPacket getStatusPkt() {
        return this.statusPkt;
    }

    private void setStatusPkt(SCSIStatusPacket statusPkt) {
        this.statusPkt = statusPkt;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
    }
}

