/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Chassis;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Chassis.ChassisPowerIpmiOptions;
import Gbt.utility.Chassis.PowerCommand;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class ChassisPowerCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "chassis";
    private GbtIPMICommandReceiver ipmiReceiver;

    public ChassisPowerCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            return false;
        }
        return ((Builder)this.commandArgs).bmcIP != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        if (((Builder)this.commandArgs).checkStatus) {
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ChassisPowerIpmiOptions.STATUS, this.commandArgs, COMMAND_NAME, this.commandID);
            if (resp instanceof NullJSONData && resp.castConcreteJSON(NullJSONData.class).isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resp.castConcreteJSON(NullJSONData.class).getMessages());
                this.commandResults.add(resp.castConcreteJSON(NullJSONData.class));
                return false;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Current chassis status : ");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, resp.toString());
            this.commandResults.add(resp);
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to set chassis power.");
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ChassisPowerIpmiOptions.CONTROL, this.commandArgs, COMMAND_NAME, this.commandID);
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set chassis power fail.");
                this.commandResults.add(temp);
                return false;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.commandResults.add(temp);
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected PowerCommand chassisType;
        private boolean checkStatus = true;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "off": {
                        this.chassisType = PowerCommand.PowerDown;
                        this.checkStatus = false;
                        break;
                    }
                    case "on": {
                        this.chassisType = PowerCommand.PowerUp;
                        this.checkStatus = false;
                        break;
                    }
                    case "cycle": {
                        this.chassisType = PowerCommand.PowerCycle;
                        this.checkStatus = false;
                        break;
                    }
                    case "reset": {
                        this.chassisType = PowerCommand.HardReset;
                        this.checkStatus = false;
                        break;
                    }
                    case "status": {
                        this.chassisType = PowerCommand.Status;
                        this.checkStatus = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public ChassisPowerCommand build() {
            return new ChassisPowerCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.chassisType = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setPowerCommand(PowerCommand chassisType) {
            this.chassisType = chassisType;
            this.checkStatus = this.chassisType == PowerCommand.Status;
            return this.getThis();
        }
    }
}

