/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import Gbt.utility.Common.GbtCommonConverters;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;

public final class GIGABYTEChecksum {
    private static final int[] GBT_CPLD_HEADER_ARRAY = new int[]{35, 71, 66, 84, 35, 82, 79, 77};

    private GIGABYTEChecksum() {
    }

    public static final int getBMCChecksum(String imagePath) {
        int checksum = 0;
        FileInputStream is = null;
        DataInputStream dis = null;
        try {
            is = new FileInputStream(imagePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            dis.readFully(buf);
            for (byte b : buf) {
                checksum += b & 0xFF;
            }
            checksum &= 0xFFFF;
            ((InputStream)is).close();
            dis.close();
        }
        catch (Exception e) {
            checksum = 0;
        }
        return checksum;
    }

    public static final int getBIOSChecksum(String imagePath) {
        int checksum = 0;
        FileInputStream is = null;
        DataInputStream dis = null;
        int[] last16Bytes = new int[16];
        try {
            is = new FileInputStream(imagePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            dis.readFully(buf);
            int i = 0;
            int getCheckSunLocation = 16;
            for (int j = length - getCheckSunLocation; j < length; ++j) {
                last16Bytes[i] = buf[j] & 0xFF;
                ++i;
            }
            checksum = last16Bytes[8] * 256 + last16Bytes[9] & 0xFFFF;
            ((InputStream)is).close();
            dis.close();
        }
        catch (Exception e) {
            checksum = 0;
        }
        return checksum;
    }

    public static final BigInteger getBIOSBigIntegerChecksum(String imagePath) {
        FileInputStream is = null;
        DataInputStream dis = null;
        BigInteger checksum = new BigInteger("0");
        try {
            is = new FileInputStream(imagePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            dis.readFully(buf);
            ((InputStream)is).close();
            dis.close();
            int BIOS_ADDRESS_START = 0;
            int BIOS_ADDRESS_END = buf.length;
            for (int i = BIOS_ADDRESS_START; i < BIOS_ADDRESS_END; ++i) {
                int temp = buf[i] & 0xFF;
                checksum = checksum.add(BigInteger.valueOf(temp));
            }
            BigInteger bitOperate = new BigInteger("ffffffff", 16);
            checksum = checksum.and(bitOperate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return checksum;
    }

    public static final byte[] getChecksumIPMIReq(byte[] Data, byte[] reqData) {
        byte ckecksum;
        int i;
        int len = Data.length + reqData.length;
        byte[] result = new byte[len + 1];
        int temp = 0;
        if (Data.length == 0) {
            System.out.println("Data length is zero !!");
            return result;
        }
        Data[3] = (byte)(256 - Data[1] - Data[2] & 0xFF);
        for (i = 0; i < len; ++i) {
            result[i] = i < Data.length ? Data[i] : reqData[i - Data.length];
        }
        for (i = 4; i < len; ++i) {
            temp = (byte)(temp + result[i]);
        }
        result[len] = ckecksum = (byte)(256 - temp & 0xFF);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean cpldCheckHeader(String filePath) {
        int[] last16Bytes = new int[16];
        FileInputStream is = null;
        FilterInputStream dis = null;
        try {
            int j;
            is = new FileInputStream(filePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            ((DataInputStream)dis).readFully(buf);
            int i = 0;
            int getCheckGBTHeaderLocation = 16;
            for (j = length - getCheckGBTHeaderLocation; j < length; ++j) {
                last16Bytes[i] = buf[j] & 0xFF;
                ++i;
            }
            for (j = 0; j < GBT_CPLD_HEADER_ARRAY.length; ++j) {
                if (GBT_CPLD_HEADER_ARRAY[j] == last16Bytes[j]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final BigInteger getBIOSAreaChecksum(String imagePath) {
        FileInputStream is = null;
        DataInputStream dis = null;
        try {
            is = new FileInputStream(imagePath);
            dis = new DataInputStream(is);
            int length = dis.available();
            byte[] buf = new byte[length];
            dis.readFully(buf);
            ((InputStream)is).close();
            dis.close();
            int FDBAD_ADDRESS = 0;
            int SIGNATURE_ADDRESS_START = FDBAD_ADDRESS + 16;
            int SIGNATURE_ADDRESS_END = FDBAD_ADDRESS + 19;
            String SIGNATURE_VALID = "5AA5F00F";
            byte[] signature = Arrays.copyOfRange(buf, SIGNATURE_ADDRESS_START, SIGNATURE_ADDRESS_END + 1);
            if (SIGNATURE_VALID.equalsIgnoreCase(GbtCommonConverters.bytesToHex(signature))) {
                System.out.println("Signature is Intel Purley!");
                int FRBA_ADDRESS = FDBAD_ADDRESS + 22;
                int FRBA_ADDRESS_REVERSE = buf[FRBA_ADDRESS] & 0xFF;
                byte low = (byte)(FRBA_ADDRESS_REVERSE & 0xF);
                byte high = (byte)(FRBA_ADDRESS_REVERSE >> 4);
                FRBA_ADDRESS_REVERSE = (byte)((byte)(low << 4) + high) & 0xFF;
                byte[] BIOS_ADDRESS_START_OFFSET = new byte[]{buf[FRBA_ADDRESS_REVERSE + 4], buf[FRBA_ADDRESS_REVERSE + 5]};
                byte[] BIOS_ADDRESS_END_OFFET = new byte[]{buf[FRBA_ADDRESS_REVERSE + 6], buf[FRBA_ADDRESS_REVERSE + 7]};
                int BIOS_ADDRESS_START_PART = GbtCommonConverters.bytesToDecReverse(BIOS_ADDRESS_START_OFFSET).intValue();
                int BIOS_ADDRESS_END_PART = GbtCommonConverters.bytesToDecReverse(BIOS_ADDRESS_END_OFFET).intValue();
                int BIOS_ADDRESS_START = BIOS_ADDRESS_START_PART << 12;
                int BIOS_ADDRESS_END = BIOS_ADDRESS_END_PART << 12 | 0xFFF;
                BigInteger checksum = new BigInteger("0");
                for (int i = BIOS_ADDRESS_START; i < BIOS_ADDRESS_END + 1; ++i) {
                    int temp = buf[i] & 0xFF;
                    checksum = checksum.add(BigInteger.valueOf(temp));
                }
                BigInteger bitOperate = new BigInteger("ffffffff", 16);
                checksum = checksum.and(bitOperate);
                return checksum;
            }
            int BIOS_ADDRESS_START = 0;
            int BIOS_ADDRESS_END = buf.length;
            BIOS_ADDRESS_END &= 0xFFFFF000;
            BigInteger checksum = new BigInteger("0");
            for (int i = BIOS_ADDRESS_START; i < BIOS_ADDRESS_END; ++i) {
                int temp = buf[i] & 0xFF;
                checksum = checksum.add(BigInteger.valueOf(temp));
            }
            BigInteger bitOperate = new BigInteger("ffffffff", 16);
            checksum = checksum.and(bitOperate);
            return checksum;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

