/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.utility.FRU.record.BaseCompatibilityInfo;
import Gbt.utility.FRU.record.DcLoadInfo;
import Gbt.utility.FRU.record.DcOutputInfo;
import Gbt.utility.FRU.record.ExtendedCompatibilityInfo;
import Gbt.utility.FRU.record.FruMultiRecordType;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.FRU.record.ManagementAccessInfo;
import Gbt.utility.FRU.record.OemInfo;
import Gbt.utility.FRU.record.PowerSupplyInfo;
import com.veraxsystems.vxipmi.common.TypeConverter;

public abstract class MultiRecordInfo
extends FruRecord {
    public static final MultiRecordInfo populateMultiRecord(byte[] fruData, int offset) {
        if ((TypeConverter.byteToInt(fruData[offset + 1]) & 0xF) != 2) {
            return null;
        }
        FruMultiRecordType recordType = FruMultiRecordType.parseInt(TypeConverter.byteToInt(fruData[offset]));
        int length = TypeConverter.byteToInt(fruData[offset + 2]);
        int currentOffset = offset + 5;
        switch (recordType) {
            case PowerSupplyInformation: {
                return new PowerSupplyInfo(fruData, currentOffset);
            }
            case DcOutput: {
                return new DcOutputInfo(fruData, currentOffset);
            }
            case DcLoad: {
                return new DcLoadInfo(fruData, currentOffset);
            }
            case ManagementAccessRecord: {
                return new ManagementAccessInfo(fruData, currentOffset, length);
            }
            case BaseCompatibilityRecord: {
                return new BaseCompatibilityInfo(fruData, currentOffset, length);
            }
            case ExtendedCompatibilityRecord: {
                return new ExtendedCompatibilityInfo(fruData, currentOffset, length);
            }
            case OemRecord: {
                return new OemInfo(fruData, currentOffset, length);
            }
        }
        return null;
    }
}

