/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo;

import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import Gbt.utility.HDDInfo.parsers.ParserCPUInfo;
import Gbt.utility.HDDInfo.parsers.ParserHDDInfo;
import Gbt.utility.HDDInfo.parsers.ParserLANInfo;
import Gbt.utility.HDDInfo.parsers.ParserMEMInfo;
import java.io.File;

public enum HwInfoCollection {
    UNKNOWN("Unknown"),
    CPU_INFO("_CPU_"),
    MEM_INFO("_MEM_"),
    HDD_INFO("_HD_"),
    LAN_INFO("_LAN_");

    private static final String UNKNOWN_HEADER_ITEM = "Unknown";
    private static final String CPU_HEADER_ITEM = "_CPU_";
    private static final String MEM_HEADER_ITEM = "_MEM_";
    private static final String HDD_HEADER_ITEM = "_HD_";
    private static final String LAN_HEADER_ITEM = "_LAN_";
    private final String header;

    private HwInfoCollection(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public final HwInfoParser createParser(File binFile) {
        switch (this) {
            case CPU_INFO: {
                return new ParserCPUInfo(binFile);
            }
            case MEM_INFO: {
                return new ParserMEMInfo(binFile);
            }
            case HDD_INFO: {
                return new ParserHDDInfo(binFile);
            }
            case LAN_INFO: {
                return new ParserLANInfo(binFile);
            }
        }
        return null;
    }
}

