/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo.parsers;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.HDDInfo.HwInfoCollection;
import Gbt.utility.HDDInfo.data.CpuHwInfo;
import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class ParserCPUInfo
extends HwInfoParser {
    public ParserCPUInfo(File binFile) {
        super(binFile, HwInfoCollection.CPU_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractJSONPOJO> parseHwInfo() {
        ArrayList<AbstractJSONPOJO> dataList = new ArrayList<AbstractJSONPOJO>();
        if (this.offset == -1) {
            return dataList;
        }
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(this.binFile));
            ((DataInputStream)dis).skipBytes(this.offset);
            byte[] signature = new byte[8];
            ((DataInputStream)dis).read(signature, 0, signature.length);
            for (int i = 0; i < 2; ++i) {
                CpuHwInfo cpuInfo = new CpuHwInfo();
                cpuInfo.setCpuNumber(new BigDecimal(i));
                cpuInfo.setHtEnable(((DataInputStream)dis).readBoolean());
                cpuInfo.setHtSupport(((DataInputStream)dis).readBoolean());
                cpuInfo.setVmxEnable(((DataInputStream)dis).readBoolean());
                cpuInfo.setVmxSupport(((DataInputStream)dis).readBoolean());
                cpuInfo.setXdEnable(((DataInputStream)dis).readBoolean());
                cpuInfo.setXdSupport(((DataInputStream)dis).readBoolean());
                cpuInfo.setTurboModeEnable(((DataInputStream)dis).readBoolean());
                cpuInfo.setTurboModeSupport(((DataInputStream)dis).readBoolean());
                byte[] reserved = new byte[24];
                ((DataInputStream)dis).read(reserved, 0, reserved.length);
                dataList.add(cpuInfo);
            }
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        catch (IOException ioe) {
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    dis = null;
                }
            }
        }
    }
}

