/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.NTP;

import com.fasterxml.jackson.annotation.JsonValue;

public enum NtpTscMode {
    UNKNOWN("unknown", 0),
    SLEW("slew", 0),
    STEP("step", 1);

    private static final String UNKNOWN_MODE_ITEM = "unknown";
    private static final String SLEW_MODE_ITEM = "slew";
    private static final String STEP_MODE_ITEM = "step";
    private final String item;
    private final byte code;

    private NtpTscMode(String item, byte code) {
        this.item = item;
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final NtpTscMode parse(String rawItem) {
        if (rawItem == null) {
            return UNKNOWN;
        }
        try {
            return NtpTscMode.valueOf(rawItem.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }

    public static final NtpTscMode parse(byte rawByte) {
        switch (rawByte) {
            case 0: {
                return SLEW;
            }
            case 1: {
                return STEP;
            }
        }
        return UNKNOWN;
    }
}

