/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SDR.SDRCommand;
import Gbt.utility.SDR.SdrInfoUpdSupportModel;
import Gbt.utility.SDR.SdrRecordPayloadData;
import Gbt.utility.SDR.SdrRepositoryInfoData;
import Gbt.utility.SDR.SdrSensorReadingData;
import Gbt.utility.SDR.SdrSensorRecordsRawData;
import Gbt.utility.SDR.SdrSensorThresholdReadingData;
import Gbt.utility.SDR.record.SensorState;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.math.BigDecimal;

public enum SDRIpmiOptions implements GbtIPMIOptions<SDRCommand.Builder>
{
    UNKNOWN(0, "unknown", 10, 0),
    GET_SDR_REPOSITORY_INFO(1, "info", 10, 32),
    GET_SDR_RESERVEID(2, "reserveid", 10, 34),
    GET_SDR_SENSOR_RECORDS(3, "list", 10, 35),
    SET_SDR_SENSOR_THRESHOLD(4, "setth", 4, 38),
    GET_SDR_SENSOR_THRESHOLD(5, "getth", 4, 39),
    GET_SDR_SENSOR_READING(6, "reading", 4, 45);

    private static final String INFO_ITEM = "info";
    private static final String RESERVEID_ITEM = "reserveid";
    private static final String SENSOR_RECORDS_ITEM = "list";
    private static final String SET_SENSOR_THRESHOLD_ITEM = "setth";
    private static final String GET_SENSOR_THRESHOLD_ITEM = "getth";
    private static final String SENSOR_READING_ITEM = "reading";
    private static final byte STORAGE_NET_FN = 10;
    private static final byte SENSOR_NET_FN = 4;
    private final int optionCode;
    private final String item;
    private final byte netFn;
    private final byte cmd;

    private SDRIpmiOptions(int optionCode, String item, byte netFn, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.netFn = netFn;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return this.netFn;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(SDRCommand.Builder commandArgs) {
        switch (this) {
            case GET_SDR_REPOSITORY_INFO: {
                return null;
            }
            case GET_SDR_RESERVEID: {
                return null;
            }
            case GET_SDR_SENSOR_RECORDS: {
                byte[] payload = new byte[6];
                byte[] buffer = TypeConverter.intToByteArray(commandArgs.sdrRecordPayload.getReservationId());
                payload[0] = buffer[3];
                payload[1] = buffer[2];
                buffer = TypeConverter.intToByteArray(commandArgs.sdrRecordPayload.getRecordId());
                payload[2] = buffer[3];
                payload[3] = buffer[2];
                payload[4] = TypeConverter.intToByte(commandArgs.sdrRecordPayload.getOffset());
                payload[5] = TypeConverter.intToByte(commandArgs.sdrRecordPayload.getBytesToRead());
                return payload;
            }
            case GET_SDR_SENSOR_THRESHOLD: {
                return new byte[]{commandArgs.sensorNumber};
            }
            case GET_SDR_SENSOR_READING: {
                return new byte[]{commandArgs.sensorNumber};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] buffer = new byte[4];
        byte[] raw = gbtResponseData.getAllResponseData();
        switch (this) {
            case GET_SDR_REPOSITORY_INFO: {
                SdrRepositoryInfoData sdrRepositoryInfoData = new SdrRepositoryInfoData();
                sdrRepositoryInfoData.setSdrVersion(raw[0]);
                System.arraycopy(raw, 1, buffer, 0, 2);
                sdrRepositoryInfoData.setRecordCount(new BigDecimal(TypeConverter.littleEndianByteArrayToInt(buffer)));
                int freeSpace = (TypeConverter.byteToInt(raw[4]) << 8) + TypeConverter.byteToInt(raw[3]);
                sdrRepositoryInfoData.setFreeSpace(new BigDecimal(freeSpace));
                System.arraycopy(raw, 5, buffer, 0, 4);
                sdrRepositoryInfoData.setAddTimestamp(GbtCommonConverters.ipmiBytesToJavaDate(buffer));
                System.arraycopy(raw, 9, buffer, 0, 4);
                sdrRepositoryInfoData.setDelTimestamp(GbtCommonConverters.ipmiBytesToJavaDate(buffer));
                sdrRepositoryInfoData.setSdrOverflow((TypeConverter.byteToInt(raw[13]) & 0x80) != 0);
                sdrRepositoryInfoData.setUpdSupportModel(SdrInfoUpdSupportModel.parse(raw[13]));
                sdrRepositoryInfoData.setDeleteSDRSupport((TypeConverter.byteToInt(raw[13]) & 8) != 0);
                sdrRepositoryInfoData.setPartialAddSDRSupport((TypeConverter.byteToInt(raw[13]) & 4) != 0);
                sdrRepositoryInfoData.setReserveSupported((TypeConverter.byteToInt(raw[13]) & 2) != 0);
                sdrRepositoryInfoData.setAllocInfoSupported((TypeConverter.byteToInt(raw[13]) & 1) != 0);
                return sdrRepositoryInfoData;
            }
            case GET_SDR_RESERVEID: {
                System.arraycopy(raw, 0, buffer, 0, 2);
                return new SdrRecordPayloadData().setRawReserveID(raw).setReservationId(TypeConverter.littleEndianByteArrayToInt(buffer));
            }
            case GET_SDR_SENSOR_RECORDS: {
                SdrSensorRecordsRawData sdrSensorRecordsData = new SdrSensorRecordsRawData();
                System.arraycopy(raw, 0, buffer, 0, 2);
                sdrSensorRecordsData.setNextRecordId(TypeConverter.littleEndianByteArrayToInt(buffer));
                byte[] recordData = new byte[raw.length - 2];
                System.arraycopy(raw, 2, recordData, 0, recordData.length);
                sdrSensorRecordsData.setSensorRecordData(recordData);
                return sdrSensorRecordsData;
            }
            case GET_SDR_SENSOR_THRESHOLD: {
                return new SdrSensorThresholdReadingData().setReadableByte(raw[0]).setLowerNonCriticalThreshold(raw[1]).setLowerCriticalThreshold(raw[2]).setLowerNonRecoverableThreshold(raw[3]).setUpperNonCriticalThreshold(raw[4]).setUpperCriticalThreshold(raw[5]).setUpperNonRecoverableThreshold(raw[6]);
            }
            case GET_SDR_SENSOR_READING: {
                int i;
                if (!gbtResponseData.isHasResponseData()) {
                    return new NullJSONData().setError(true).setMessages("No response data.");
                }
                if (raw.length < 3 || (raw[1] & 0xFF) == 224) {
                    return new SdrSensorReadingData().setSensorState(SensorState.Invalid).setSensorStateValid(false);
                }
                SdrSensorReadingData responseData = new SdrSensorReadingData().setSensorReading(raw[0]).setSensorStateValid((TypeConverter.byteToInt(raw[1]) & 0x20) == 0).setSensorState(SensorState.parseInt(TypeConverter.byteToInt(raw[2]) & 0x3F));
                boolean[] states = raw.length > 3 ? new boolean[16] : new boolean[8];
                for (i = 0; i < 8; ++i) {
                    states[i] = (TypeConverter.byteToInt(raw[2]) & 1 << i) != 0;
                }
                if (raw.length > 3) {
                    for (i = 0; i < 7; ++i) {
                        states[i + 8] = (TypeConverter.byteToInt(raw[3]) & 1 << i) != 0;
                    }
                    states[15] = Boolean.FALSE;
                }
                return responseData.setStatesAsserted(states);
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown parse option of sdr command.");
    }

    public static final SDRIpmiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        switch (rawString.toLowerCase()) {
            case "info": {
                return GET_SDR_REPOSITORY_INFO;
            }
            case "setth": {
                return SET_SDR_SENSOR_THRESHOLD;
            }
            case "getth": {
                return GET_SDR_SENSOR_THRESHOLD;
            }
            case "list": {
                return GET_SDR_SENSOR_RECORDS;
            }
        }
        return UNKNOWN;
    }
}

